% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{is.in.data}
\alias{is.in.data}
\title{Check a point belong to a given data set.}
\usage{
is.in.data(p, Dt)
}
\arguments{
\item{p}{A 2D point for which the function checks membership to the data set \code{Dt}}

\item{Dt}{A set of 2D points representing the set of data points}
}
\value{
\code{TRUE} if \code{p} belongs to the data set \code{Dt}.
}
\description{
returns \code{TRUE} if the point \code{p} of any dimension is inside the data set \code{Dt} of the same dimension as \code{p};
otherwise returns \code{FALSE}.
}
\examples{
n<-10
dat<-cbind(runif(n),runif(n))

P<-dat[7,]
is.in.data(P,dat)
is.in.data(P,dat[7,])

P<-dat[7,]+10^(-7)
is.in.data(P,dat)

P<-dat[7,]+10^(-9)
is.in.data(P,dat)

is.in.data(P,P)

is.in.data(c(2,2),c(2,2))

#for 1D data
n<-10
dat<-runif(n)

\dontrun{
P<-dat[7]
is.in.data(P,dat)  #Both arguments must be of the same dimension
#this does not work because both entries are treated as vectors of different dimensions
}
P<-dat[7]
is.in.data(P,dat[7])  #this works because both entries are treated as 1D vectors

dat<-as.matrix(dat)
is.in.data(P,dat)
#this works, because P is a 1D point, and dat is treated as a set of 10 1D points

P<-dat[7]+10^(-7)
is.in.data(P,dat)

P<-dat[7]+10^(-9)
is.in.data(P,dat)

is.in.data(P,P)

#for 3D data
n<-10
dat<-cbind(runif(n),runif(n),runif(n))

P<-dat[7,]
is.in.data(P,dat)
is.in.data(P,dat[7,])

P<-dat[7,]+10^(-7)
is.in.data(P,dat)

P<-dat[7,]+10^(-9)
is.in.data(P,dat)

is.in.data(P,P)

n<-10
dat<-cbind(runif(n),runif(n))
P<-dat[7,]
is.in.data(P,dat)

dat.fr<-data.frame(a=dat)
is.in.data(P,dat.fr)

}
