% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IncMatPEtri}
\alias{IncMatPEtri}
\title{Incidence matrix for Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one triangle case}
\usage{
IncMatPEtri(Xp, tri, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of PE-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.}
}
\value{
Incidence matrix for the PE-PCD with vertices being 2D data set, \code{Xp},
in the triangle \code{tri} with vertex regions based on center \code{M}
}
\description{
Returns the incidence matrix for the PE-PCD whose vertices are the given 2D numerical data set, \code{Xp},
in the triangle \code{tri}\eqn{=T(v=1,v=2,v=3)}.

PE proximity regions are constructed with respect to triangle \code{tri}
with expansion parameter \eqn{r \ge 1} and vertex regions are based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.
Loops are allowed, so the diagonal entries are all equal to 1.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)
IM<-IncMatPEtri(Xp,Tr,r=1.25,M)

IM
dom.greedy(IM) #try also dom.exact(IM)
IndUBdom(IM,3)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatPE}}, \code{\link{IncMatCStri}}, and  \code{\link{IncMatAStri}}
}
\author{
Elvan Ceyhan
}
