% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{num.arcsPEend.int}
\alias{num.arcsPEend.int}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - end interval case}
\usage{
num.arcsPEend.int(Xp, int, r)
}
\arguments{
\item{Xp}{A \code{vector} of 1D points which constitute the vertices of the digraph.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}
}
\value{
Number of arcs for the PE-PCD with vertices being 1D data set, \code{Xp},
expansion parameter, \eqn{r \ge 1}, for the end intervals.
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) whose
vertices are a 1D numerical data set, \code{Xp}, outside the interval \code{int}\eqn{=(a,b)}.

PE proximity region is constructed only with expansion parameter \eqn{r \ge 1} for points outside the interval \eqn{(a,b)}.
End vertex regions are based on the end points of the interval,
i.e., the corresponding vertex region is an interval as \eqn{(-\infty,a)} or \eqn{(b,\infty)} for the interval \eqn{(a,b)}.
For the number of arcs, loops are not allowed, so arcs are only possible for points outside
the interval, \code{int}, for this function.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
a<-0; b<-10; int<-c(a,b)

n<-5
XpL<-runif(n,a-5,a)
XpR<-runif(n,b,b+5)
Xp<-c(XpL,XpR)

r<-1.2
num.arcsPEend.int(Xp,int,r)
num.arcsPEend.int(Xp,int,r=2)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.arcsPEmid.int}}, \code{\link{num.arcsPE1D}}, \code{\link{num.arcsCSmid.int}}, and \code{\link{num.arcsCSend.int}}
}
\author{
Elvan Ceyhan
}
