% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.edge.basic.triCM}
\alias{rel.edge.basic.triCM}
\title{The index of the \eqn{CM}-edge region
in a standard basic triangle form that contains a point}
\usage{
rel.edge.basic.triCM(p, c1, c2)
}
\arguments{
\item{p}{A 2D point for which \eqn{CM}-edge region it resides in is
to be determined in the
standard basic triangle form \eqn{T_b}.}

\item{c1, c2}{Positive real numbers
which constitute the upper vertex of the standard basic triangle form
(i.e., the vertex adjacent to the shorter edges of \eqn{T_b});
\eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and
\eqn{(1-c_1)^2+c_2^2 \le 1}.}
}
\value{
A \code{list} with three elements

\item{re}{Index of the \eqn{CM}-edge region that contains point, \code{p}
in the standard basic triangle form \eqn{T_b}}
\item{tri}{The vertices of the triangle,
where row labels are \eqn{A=(0,0)}, \eqn{B=(1,0)}, and \eqn{C=(c_1,c_2)}
with edges are labeled as 3 for edge \eqn{AB},
1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.}
\item{desc}{Description of the edge labels}
}
\description{
Returns the index of the edge
whose region contains point, \code{p}, in the
standard basic triangle form
\eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2)}
where \eqn{c_1} is in \eqn{[0,1/2]},
\eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1} with
edge regions based on center of mass \eqn{CM=(A+B+C)/3}.

Edges are labeled as 3 for edge \eqn{AB},
1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.
If the point, \code{p}, is not inside \code{tri},
then the function yields \code{NA} as output.
Edge region 1 is the triangle \eqn{T(B,C,CM)},
edge region 2 is \eqn{T(A,C,CM)},
and edge region 3 is \eqn{T(A,B,CM)}.

Any given triangle can be mapped to the standard basic triangle form
by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle.
 Hence, standard basic triangle form is useful for simulation
studies under the uniformity hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6
P<-c(.4,.2)
rel.edge.basic.triCM(P,c1,c2)

A<-c(0,0);B<-c(1,0);C<-c(c1,c2);
Tb<-rbind(A,B,C)
CM<-(A+B+C)/3

rel.edge.basic.triCM(A,c1,c2)
rel.edge.basic.triCM(B,c1,c2)
rel.edge.basic.triCM(C,c1,c2)
rel.edge.basic.triCM(CM,c1,c2)

n<-20  #try also n<-40
Xp<-runif.basic.tri(n,c1,c2)$g

re<-vector()
for (i in 1:n)
  re<-c(re,rel.edge.basic.triCM(Xp[i,],c1,c2)$re)
re

Xlim<-range(Tb[,1],Xp[,1])
Ylim<-range(Tb[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tb,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(Xp,pch=".")
polygon(Tb)
L<-Tb; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)
text(Xp,labels=factor(re))

txt<-rbind(Tb,CM)
xc<-txt[,1]+c(-.03,.03,.02,0)
yc<-txt[,2]+c(.02,.02,.02,-.04)
txt.str<-c("A","B","C","CM")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.edge.triCM}}, \code{\link{rel.edge.tri}},
\code{\link{rel.edge.basic.tri}}, \code{\link{rel.edge.std.triCM}}, and \code{\link{edge.reg.triCM}}
}
\author{
Elvan Ceyhan
}
