% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{group_test}
\alias{group_test}
\title{Performs multiple mean comparisons for a data.frame}
\usage{
group_test(
  df,
  group,
  metadata = NULL,
  method = "wilcox.test",
  pattern = NULL,
  p.adjust.method = "none",
  threads = 1,
  verbose = TRUE
)
}
\arguments{
\item{df}{a data.frame}

\item{group}{The compare group (categories) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of df.}

\item{metadata}{sample information dataframe contains group}

\item{method}{the type of test. Default is wilcox.test. Allowed values include:
\itemize{\item \code{\link[stats]{t.test}} (parametric) and \code{\link[stats]{wilcox.test}} (non-parametric). Perform comparison between two groups of samples. If the grouping variable contains more than two levels, then a pairwise comparison is performed.
\item \code{\link[stats]{anova}} (parametric) and \code{\link[stats]{kruskal.test}} (non-parametric). Perform one-way ANOVA test comparing multiple groups.
\item \code{\link[stats]{chisq.test}},  performs chi-squared contingency table tests and goodness-of-fit tests.
\item 'pearson', 'kendall', or 'spearman' (correlation), see \code{\link[stats]{cor}}.}}

\item{pattern}{a named vector matching the group, e.g. c('G1'=1,'G2'=3,'G3'=2), use the correlation analysis with specific pattern to calculate p-value.}

\item{p.adjust.method}{p.adjust.method, see \code{\link[stats]{p.adjust}}, default BH.}

\item{threads}{default 1}

\item{verbose}{logical}
}
\value{
data.frame
}
\description{
Performs multiple mean comparisons for a data.frame
}
\examples{
data(otutab)
group_test(otutab, metadata$Group, method = "kruskal.test")
group_test(otutab[, 1:12], metadata$Group[1:12], method = "wilcox.test")
}
