% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gwcode_to_cow.R
\name{add_gwcode_to_cow}
\alias{add_gwcode_to_cow}
\title{Add Gleditsch-Ward state system codes to dyad-year or state-year data with Correlates of War state codes.}
\usage{
add_gwcode_to_cow(data)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed") or a state-year data frame.}
}
\value{
\code{add_gwcode_to_cow()} takes a dyad-year data frame or state-year data frame that already has Correlates of War
state system codes and adds their corollary Gleditsch-Ward codes.
}
\description{
\code{add_gwcode_to_cow()} allows you to add estimates of democracy to either dyad-year or state-year data.
}
\details{
The \code{data-raw} directory on the project's Github contains more information about the underlying data that assists
in merging in these codes.

The user will invariably need to be careful and ask why they want these data included. The issue here is that both have a different
composition and the merging process will not (and cannot) be perfect. We can note that a case like Serbia/Yugoslavia is not too difficult
to handle (since "Serbia" never overlaps with "Yugoslavia" in the Gleditsch-Ward data and Correlates of War understands Serbia as the
predecessor state, dominant state, and successor state to Yugoslavia). However, there is greater weirdness with a case like Yemen/Yemen
Arab Republic. The script will *not* create state-year or dyad-year duplicates for the Correlates of War codes. The size of the original data
remain unchanged. However, there will be some year duplicates for various Gleditsch-Ward codes (e.g. Yemen, again). Use with care. You can also use
the \code{countrycode} package. Whether you use this function or the \code{countrycode} package, do *not* do this kind of merging without assessing
the output.
}
\examples{
\dontrun{
library(magrittr)
library(peacesciencer)


cow_ddy \%>\% add_gwcode_to_cow()

create_stateyears() \%>\% add_gwcode_to_cow()
}

}
\author{
Steven V. Miller
}
