% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_stock_adj.R
\name{md_stock_adjust}
\alias{md_stock_adjust}
\title{adjust stock price for split and dividend}
\usage{
md_stock_adjust(dt, adjust = FALSE, source = NULL, ...)
}
\arguments{
\item{dt}{a list/dataframe of time series datasets that didnt adjust for split or dividend.}

\item{adjust}{whether to adjust the OHLC prices, defaults to FALSE. If it is NULL, return the original data; if it is FALSE, create close_adj or change_pct column if not exist; if it is TRUE, adjust all open, high, low, close columns.
For the yahoo data, the adjustment is based on the close_adj; for the 163 data, the adjustment is based on the cumulative products of close/close_prev.}

\item{source}{the available data sources are 'yahoo' and '163'. The source will set to yahoo, if the dt has close_adj column; and will set to 163, if the dt has close_prev column.}

\item{...}{Additional parameters.}
}
\description{
\code{md_stock_adjust} adjusts the open, high, low and close stock prices for split and dividend.
}
\examples{
\donttest{
dt = md_stock('600547', source = '163', date_range = 'max')

dtadj = md_stock_adjust(dt, source = '163')
}
}
