% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_freq.R
\name{pq_freq}
\alias{pq_freq}
\title{converting frequency of daily data}
\usage{
pq_freq(dt, freq = "monthly", date_type = "eop")
}
\arguments{
\item{dt}{a list/dataframe of time series dataset.}

\item{freq}{the frequency that the input daily data will converted to. It supports weekly, monthly, quarterly and yearly.}

\item{date_type}{the available date type are eop (end of period) and bop (bebinning of period), defaults to the eop.}
}
\description{
\code{pq_freq} convert a daily OHLC dataframe into a specified frequency.
}
\examples{
data(dt_ssec)
dat1_weekly = pq_freq(dt_ssec, "weekly")

data(dt_banks)
dat2_weekly = pq_freq(dt_banks, "monthly")

}
