% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeAges.R
\name{calculateEmpiricalDensity}
\alias{calculateEmpiricalDensity}
\title{Calculate Empirical Age Density}
\usage{
calculateEmpiricalDensity(
  data,
  aff_column = "aff",
  age_column = "age",
  sex_column = "sex",
  geno_column = "geno",
  n_points = 10000,
  sex_specific = TRUE
)
}
\arguments{
\item{data}{A data frame containing the family data}

\item{aff_column}{Name of the affection status column}

\item{age_column}{Name of the age column}

\item{sex_column}{Name of the sex column}

\item{geno_column}{Name of the genotype column}

\item{n_points}{Number of points to use in density estimation}

\item{sex_specific}{Logical; whether to calculate sex-specific densities}
}
\value{
A list of density objects for different subgroups (tested/untested, male/female)
}
\description{
Calculates empirical age density distributions for different subgroups in the data,
separated by sex and genetic testing status.
}
