% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_complex.R
\name{tw_complex}
\alias{tw_complex}
\title{Permutation Test for Two-Way Layout with Extra Factors}
\usage{
tw_complex(df, res, mains, nested, nuis, seed = 1, rand = 1999)
}
\arguments{
\item{df}{a data frame with at least three columns.}

\item{res}{a character string, name of response variable.}

\item{mains}{two character strings, names of two main factors.}

\item{nested}{(optional) a character string, name of the nested factor.}

\item{nuis}{(optional) a character string, name of the nuisance factor.}

\item{seed}{an integer, the seed for random number generation. Setting a seed
ensures the reproducibility of the result. See \code{\link{set.seed}} for
more details.}

\item{rand}{an integer, the number of randomization samples. The default value
is 1999.}
}
\value{
\code{tw_complex} returns a list with 3 main components:
\item{\code{lm},
 \code{glmer}, or \code{lmer}}{model results.}
 \item{\code{anova}}{anova table.} \item{\code{perm}}{permutation test
 results with F-statistics, p-values, and strength of evidence.}
}
\description{
\code{tw_complex} performs the permutation test for ANOVA of two-factor
experiments with complex design.
}
\details{
\code{res}, \code{mains}, \code{nested}, and \code{nuis} refer to
 column names in \code{df}. While \code{nuis} column must be a numeric
 vector, \code{mains} and \code{nested} columns must be factors. \code{res}
 can be a numeric or logical vector. \cr \cr \code{tw_complex} currently
 support linear models with only \code{mains}, generalized linear
 mixed-effects models with \code{mains} and \code{nested}, and linear
 mixed-effects models with \code{mains}, \code{nested}, and \code{nuis}.
}
\examples{
\donttest{
tw_complex(df = subset(Cu, run == "Jan",
select = c("copper", "temp", "sediment")),
res = "sediment",
mains = c("copper", "temp"))
}

#might take more than 5s in some machines

}
\references{
Manly, B. F. J. (2007). Randomization, bootstrap, and Monte Carlo
 methods in biology (3rd ed). Chapman & Hall/ CRC. \cr \cr Ernst, M. D.
 (2004). Permutation Methods: A Basis for Exact Inference. Statistical
 Science, 19(4), 676–685. \doi{10.1214/088342304000000396}. \cr \cr Anderson,
 M., & Braak, C. T. (2003). Permutation tests for multi-factorial analysis of
 variance. Journal of Statistical Computation and Simulation, 73(2), 85–113.
 \doi{10.1080/00949650215733}.
}
\seealso{
\code{\link{lm}}, \code{\link{glmer}}, and \code{\link{lmer}}.
}
