% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{set_app_parameters}
\alias{set_app_parameters}
\title{Set Application Parameters}
\usage{
set_app_parameters(
  title,
  titleinfo = NULL,
  loglevel = "DEBUG",
  showlog = TRUE,
  app_version = "1.0.0"
)
}
\arguments{
\item{title}{application title text}

\item{titleinfo}{character string, HTML value or NULL
\itemize{
\item{A \strong{character} string will be used to set a link target.  This means the user
will be able to click on the application title and be redirected in a new
window to whatever value is given in the string.  Any valid URL, File, or
other script functionality that would normally be accepted in an <a href=...>
tag is allowed.}
\item{An \strong{HTML} value will be used to as the HTML content for a modal pop-up
window that will appear on-top of the application when the user clicks on the
application title.}
\item{Supplying \strong{NULL} will disable the title link functionality.}
}}

\item{loglevel}{character string designating the log level to use for
the userlog (default = 'DEBUG')}

\item{showlog}{enable or disable the visible userlog at the bottom of the
body on the application.  Logging will still take place, this disables the
visible functionality only.}

\item{app_version}{character string designating the application version (default = '1.0.0').}
}
\description{
This function sets global parameters customizing the shiny application.
}
\section{Shiny Usage}{

Call this function from \code{program/global.R} to set the application
parameters.
}

