% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadablePlot.R
\name{downloadablePlot}
\alias{downloadablePlot}
\title{downloadablePlot module server function}
\usage{
downloadablePlot(
  id,
  logger,
  filenameroot,
  aspectratio = 1,
  downloadfxns = list(),
  visibleplot
)
}
\arguments{
\item{id}{the ID of the Module's UI element}

\item{logger}{logger to use}

\item{filenameroot}{the base text used for user-downloaded file - can be
either a character string or a reactive expression returning a character
string}

\item{aspectratio}{the downloaded chart image width:height ratio (ex:
1 = square, 1.3 = 4:3, 0.5 = 1:2).  Where not applicable for a download type
it is ignored (e.g. data, html downloads)}

\item{downloadfxns}{a \strong{named} list of functions providing download
images or data tables as return values.  The names for the list should be
the same names that were used when the plot UI was created.}

\item{visibleplot}{function or reactive expression providing the plot to
display as a return value.  This function should require no input parameters.}
}
\value{
Reactive expression containing the currently selected plot to be available for display and download
}
\description{
Server-side function for the downloadablePlotUI.  This is a custom
plot output paired with a linked downloadFile button.
}
\section{Notes}{

When there are no values to download in any of the linked downloadfxns the
button will be hidden as there is nothing to download.
}

\section{Shiny Usage}{

This function is not called directly by consumers - it is accessed in
server.R using the same id provided in \code{downloadablePlotUI}:

\strong{\code{downloadablePlot(id, logger, filenameroot,
downloadfxns, visibleplot)}}
}

\examples{
if (interactive()) {
  library(shiny)
  library(ggplot2)
  library(periscope2)
  shinyApp(ui = fluidPage(fluidRow(column(width = 12,
     downloadablePlotUI("object_id1",
                        downloadtypes      = c("png", "csv"),
                        download_hovertext = "Download plot and data",
                        height             = "500px",
                        btn_halign         = "left")))),
    server = function(input, output) {
      download_plot <- function() {
        ggplot(data = mtcars, aes(x = wt, y = mpg)) +
        geom_point(aes(color = cyl)) +
        theme(legend.justification = c(1, 1),
              legend.position      = c(1, 1),
              legend.title         = element_blank()) +
        ggtitle("GGPlot Example ") +
        xlab("wt") +
        ylab("mpg")
      }
      downloadablePlot(id           = "object_id1",
                       logger       = "",
                       filenameroot = "mydownload1",
                       downloadfxns = list(png = download_plot, csv = reactiveVal(mtcars)),
                       aspectratio  = 1.33,
                       visibleplot  = download_plot)
  })
}

}
\seealso{
\link[periscope2]{downloadablePlotUI}

\link[periscope2]{appResetButton}

\link[periscope2]{appReset}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadableTable}

\link[periscope2]{logViewerOutput}
}
