% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perrySplits.R
\name{bootSamples}
\alias{bootSamples}
\alias{print.bootSamples}
\title{Bootstrap samples}
\usage{
bootSamples(n, R = 1, type = c("0.632", "out-of-bag"), grouping = NULL)
}
\arguments{
\item{n}{an integer giving the number of observations for which to draw
bootstrap samples.  This is ignored if \code{grouping} is supplied in
order to respect the group structure of the data in the bootstrap samples.}

\item{R}{an integer giving the number of bootstrap samples.}

\item{type}{a character string specifying a bootstrap estimator.  Possible
values are \code{"0.632"} (the default), or \code{"out-of-bag"}.}

\item{grouping}{a factor specifying groups of observations.  If supplied,
the groups are resampled rather than individual observations such that all
observations within a group belong either to the bootstrap sample or the
test data.}
}
\value{
An object of class \code{"bootSamples"} with the following
components:
\describe{
  \item{\code{n}}{an integer giving the number of observations or groups.}
  \item{\code{R}}{an integer giving the number of bootstrap samples.}
  \item{\code{subsets}}{an integer matrix in which each column contains the
  indices of the observations or groups in the corresponding bootstrap
  sample.}
  \item{\code{grouping}}{a list giving the indices of the observations
  belonging to each group.  This is only returned if a grouping factor
  has been supplied.}
}
}
\description{
Draw bootstrap samples of observations or groups of observations and specify
which bootstrap estimator of prediction error to compute.
}
\note{
This is a simple wrapper function for \code{\link{perrySplits}} with a
control object generated by \code{\link{bootControl}}.
}
\examples{
set.seed(1234)  # set seed for reproducibility
bootSamples(20)
bootSamples(20, R = 10)

}
\references{
Efron, B. (1983) Estimating the error rate of a prediction rule: improvement
on cross-validation.  \emph{Journal of the American Statistical
Association}, \bold{78}(382), 316--331.
}
\seealso{
\code{\link{perrySplits}}, \code{\link{bootControl}},
\code{\link{cvFolds}}, \code{\link{randomSplits}}
}
\author{
Andreas Alfons
}
\keyword{utilities}
