% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/papers_to_dataframe.R
\name{onepetro_page_to_dataframe}
\alias{onepetro_page_to_dataframe}
\title{Reads a OnePetro URL and converts it to a dataframe}
\usage{
onepetro_page_to_dataframe(url)
}
\arguments{
\item{url}{char a OnePetro type URL}
}
\description{
A OnePetro URL with a query is read into a HTML page and
converted to a dataframe
}
\examples{
# Example 1
# Search papers with keyword "smartwell"
url_sw <- "https://www.onepetro.org/search?q=smartwell"
onepetro_page_to_dataframe(url_sw)
# Example 2
# Search for exact words ""vertical lift performance"
url_vlp <- "https://www.onepetro.org/search?q=\%22vertical+lift+performance\%22"
onepetro_page_to_dataframe(url_vlp)
}
