% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{DELETE}
\alias{DELETE}
\title{Generate a PostgreSQL DELETE statement, optionally execute the statement if con is not NULL.}
\usage{
DELETE(schema = NULL, table, where = NULL, con = NULL)
}
\arguments{
\item{schema}{A string, the schema name of the SQL table to DELETE from.}

\item{table}{A string, the table name of the SQL table to DELETE from.}

\item{where}{A named list, names are the columns for comparison, values are lists with a comparison operator and a value the comparison operator will check against. ex: list(col1 = list(comparison = "=", value = quoteText("b")))}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL DELETE statement; or the results retrieved by DBI::dbGetQuery after executing the statement.
}
\description{
Generate a PostgreSQL DELETE statement, optionally execute the statement if con is not NULL.
}
\examples{
DELETE(
schema = "test",
table = "table1",
where = list(
  col1 = list(comparison = "=", value = quoteText("b")),
  col2 = list(comparison = "IS", value = "NULL")
)
)
}
