/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import net.sf.eps2pgf.Options;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.PSStringInputStream;
import net.sf.eps2pgf.io.TextHandler;
import net.sf.eps2pgf.io.TextReplacements;
import net.sf.eps2pgf.ps.Curveto;
import net.sf.eps2pgf.ps.DSCHeader;
import net.sf.eps2pgf.ps.DictStack;
import net.sf.eps2pgf.ps.ExecStack;
import net.sf.eps2pgf.ps.GstateStack;
import net.sf.eps2pgf.ps.Image;
import net.sf.eps2pgf.ps.Lineto;
import net.sf.eps2pgf.ps.Moveto;
import net.sf.eps2pgf.ps.Parser;
import net.sf.eps2pgf.ps.Path;
import net.sf.eps2pgf.ps.PathSection;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorDictStackUnderflow;
import net.sf.eps2pgf.ps.errors.PSErrorIOError;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidExit;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidStop;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorStackUnderflow;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.errors.PSErrorUnmatchedMark;
import net.sf.eps2pgf.ps.errors.QuitOpExecuted;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectBool;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectFile;
import net.sf.eps2pgf.ps.objects.PSObjectFont;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectMark;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectNull;
import net.sf.eps2pgf.ps.objects.PSObjectOperator;
import net.sf.eps2pgf.ps.objects.PSObjectReal;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.Encoding;
import net.sf.eps2pgf.ps.resources.ResourceManager;
import net.sf.eps2pgf.ps.resources.colors.DeviceCMYK;
import net.sf.eps2pgf.ps.resources.colors.DeviceGray;
import net.sf.eps2pgf.ps.resources.colors.DeviceRGB;
import net.sf.eps2pgf.ps.resources.colors.PSColor;
import net.sf.eps2pgf.ps.resources.filters.EexecDecode;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;
import net.sf.eps2pgf.ps.resources.fonts.FontManager;
import net.sf.eps2pgf.ps.resources.outputdevices.CacheDevice;
import net.sf.eps2pgf.ps.resources.outputdevices.LOLDevice;
import net.sf.eps2pgf.ps.resources.outputdevices.NullDevice;
import net.sf.eps2pgf.ps.resources.outputdevices.OutputDevice;
import net.sf.eps2pgf.ps.resources.outputdevices.PGFDevice;
import net.sf.eps2pgf.util.ArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private ArrayStack<PSObject> opStack = new ArrayStack();
    private DictStack dictStack;
    private ExecStack execStack = new ExecStack();
    private GstateStack gstate;
    private TextHandler textHandler;
    private DSCHeader header;
    private Path defaultClippingPath;
    private ResourceManager resourceManager;
    private Options options;
    private final Logger log = Logger.getLogger("net.sourceforge.eps2pgf");
    private long initializationTime;

    public Interpreter(Writer writer, Options options, DSCHeader dSCHeader, TextReplacements textReplacements) throws ProgramError, PSError, IOException {
        OutputDevice outputDevice;
        this.options = options;
        switch (options.getOutputType()) {
            case PGF: {
                outputDevice = new PGFDevice(writer, this.options);
                break;
            }
            case LOL: {
                outputDevice = new LOLDevice(writer);
                break;
            }
            default: {
                throw new ProgramError("Unknown output device (" + (Object)((Object)options.getOutputType()) + ").");
            }
        }
        this.gstate = new GstateStack(outputDevice);
        this.header = dSCHeader;
        this.textHandler = new TextHandler(this.gstate, textReplacements, options.getTextmode());
        this.initialize();
    }

    public Interpreter() throws ProgramError, PSError, IOException {
        NullDevice nullDevice = new NullDevice();
        this.gstate = new GstateStack(nullDevice);
        double[] dArray = new double[]{-28346.46, -28346.46, 28346.46, 28346.46};
        this.header = new DSCHeader(dArray);
        this.options = new Options();
        this.textHandler = new TextHandler(this.gstate);
        this.initialize();
    }

    void initialize() throws IOException, PSError, ProgramError {
        double d;
        double d2;
        double d3;
        double d4;
        this.initializationTime = System.currentTimeMillis();
        Encoding.initialize();
        this.resourceManager = new ResourceManager();
        this.setDictStack(new DictStack(this));
        this.gstate.current().getDevice().init();
        this.gstate.current().setcolorspace(new PSObjectName("DeviceGray", true));
        double[] dArray = this.header.getBoundingBox();
        if (dArray != null) {
            d4 = dArray[0];
            d3 = dArray[1];
            d2 = dArray[2];
            d = dArray[3];
        } else {
            d4 = 0.0;
            d3 = 0.0;
            d2 = 595.276;
            d = 841.89;
        }
        this.gstate.current().moveto(d4, d3);
        this.gstate.current().lineto(d2, d3);
        this.gstate.current().lineto(d2, d);
        this.gstate.current().lineto(d4, d);
        this.gstate.current().getPath().closepath();
        this.defaultClippingPath = this.gstate.current().getPath();
        this.op_newpath();
        if (dArray != null) {
            this.op_initclip();
        } else {
            this.gstate.current().setClippingPath(this.defaultClippingPath.clone());
        }
    }

    void setDictStack(DictStack dictStack) {
        this.dictStack = dictStack;
    }

    public DictStack getDictStack() {
        return this.dictStack;
    }

    public ExecStack getExecStack() {
        return this.execStack;
    }

    public ArrayStack<PSObject> getOpStack() {
        return this.opStack;
    }

    public void start() throws ProgramError, PSError, IOException {
        try {
            this.run();
        }
        catch (QuitOpExecuted quitOpExecuted) {
        }
        catch (PSError pSError) {
            this.log.severe("A PostScript error occurred.");
            this.log.severe("    Type: " + pSError.getMessage());
            int n = Math.min(this.getOpStack().size(), 10);
            this.log.severe("    Operand stack (max top 10 items):");
            if (n == 0) {
                this.log.severe("      (empty)");
            } else {
                for (int i = 0; i < n; ++i) {
                    this.log.severe("      |- " + this.getOpStack().peek(i).isis());
                }
                if (n < this.getOpStack().size()) {
                    this.log.severe("      (rest of stack suppressed)");
                }
            }
            this.gstate.current().getDevice().finish();
            throw pSError;
        }
        this.gstate.current().getDevice().finish();
    }

    public void run() throws PSError, ProgramError {
        while (this.getExecStack().size() > 0) {
            PSObject pSObject = this.getExecStack().getNextToken();
            if (pSObject == null) continue;
            this.executeObject(pSObject, false);
        }
    }

    public void runObject(PSObject pSObject) throws PSError, ProgramError {
        PSObject pSObject2 = this.execStack.getTop();
        this.executeObject(pSObject);
        try {
            while (this.execStack.getTop() != pSObject2) {
                PSObject pSObject3 = this.getExecStack().getNextToken();
                if (pSObject3 == null) continue;
                this.executeObject(pSObject3, false);
            }
        }
        catch (PSError pSError) {
            while (this.execStack.getTop() != pSObject2) {
                this.getExecStack().pop();
            }
            throw pSError;
        }
    }

    public void executeObject(PSObject pSObject) throws PSError, ProgramError {
        this.executeObject(pSObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeObject(PSObject pSObject, boolean bl) throws PSError, ProgramError {
        StackTraceElement[] stackTraceElementArray;
        if (pSObject.isLiteral()) {
            this.getOpStack().push(pSObject);
            return;
        }
        if (pSObject instanceof PSObjectArray) {
            if (bl) {
                this.getExecStack().push(pSObject);
                return;
            }
            this.getOpStack().push(pSObject);
            return;
        }
        if (pSObject instanceof PSObjectString) {
            this.getExecStack().push(pSObject);
            return;
        }
        if (pSObject instanceof PSObjectFile) {
            this.getExecStack().push(pSObject);
            return;
        }
        if (pSObject instanceof PSObjectName) {
            PSObjectName pSObjectName = pSObject.toName();
            PSObject pSObject2 = this.getDictStack().lookup(pSObjectName);
            if (pSObject2 == null) {
                throw new PSErrorUndefined(pSObjectName.toString());
            }
            this.executeObject(pSObject2.dup());
            return;
        }
        if (!(pSObject instanceof PSObjectOperator)) {
            if (!(pSObject instanceof PSObjectNull)) return;
            return;
        }
        Throwable throwable = null;
        try {
            try {
                ((PSObjectOperator)pSObject).getOpMethod().invoke((Object)this, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof PSError) {
                    throw (PSError)invocationTargetException.getCause();
                }
                if (invocationTargetException.getCause() instanceof ProgramError) {
                    throw (ProgramError)invocationTargetException.getCause();
                }
                throwable = invocationTargetException.getCause();
                Object var6_9 = null;
                if (throwable == null) return;
                this.log.severe("An unexpected exception occurred during execution of an operator.");
                this.log.severe("    Type: " + throwable);
                this.log.severe("    Message: " + throwable.getMessage());
                this.log.severe("    Cause: " + throwable.getCause());
                this.log.severe("    Stack trace:");
                StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
                int n = stackTraceElementArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
                    this.log.severe("      |- " + stackTraceElement);
                    ++n2;
                }
                throw new ProgramError("Unexpected exception during in operator call.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throwable = illegalAccessException;
                Object var6_10 = null;
                if (throwable == null) return;
                this.log.severe("An unexpected exception occurred during execution of an operator.");
                this.log.severe("    Type: " + throwable);
                this.log.severe("    Message: " + throwable.getMessage());
                this.log.severe("    Cause: " + throwable.getCause());
                this.log.severe("    Stack trace:");
                StackTraceElement[] stackTraceElementArray3 = throwable.getStackTrace();
                int n = stackTraceElementArray3.length;
                int n3 = 0;
                while (n3 < n) {
                    StackTraceElement stackTraceElement = stackTraceElementArray3[n3];
                    this.log.severe("      |- " + stackTraceElement);
                    ++n3;
                }
                throw new ProgramError("Unexpected exception during in operator call.");
            }
            Object var6_8 = null;
            if (throwable == null) return;
            this.log.severe("An unexpected exception occurred during execution of an operator.");
            this.log.severe("    Type: " + throwable);
            this.log.severe("    Message: " + throwable.getMessage());
            this.log.severe("    Cause: " + throwable.getCause());
            this.log.severe("    Stack trace:");
            stackTraceElementArray = throwable.getStackTrace();
        }
        catch (Throwable throwable2) {
            Object var6_11 = null;
            if (throwable == null) throw throwable2;
            this.log.severe("An unexpected exception occurred during execution of an operator.");
            this.log.severe("    Type: " + throwable);
            this.log.severe("    Message: " + throwable.getMessage());
            this.log.severe("    Cause: " + throwable.getCause());
            this.log.severe("    Stack trace:");
            StackTraceElement[] stackTraceElementArray4 = throwable.getStackTrace();
            int n = stackTraceElementArray4.length;
            int n4 = 0;
            while (n4 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray4[n4];
                this.log.severe("      |- " + stackTraceElement);
                ++n4;
            }
            throw new ProgramError("Unexpected exception during in operator call.");
        }
        int n = stackTraceElementArray.length;
        int n5 = 0;
        while (n5 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n5];
            this.log.severe("      |- " + stackTraceElement);
            ++n5;
        }
        throw new ProgramError("Unexpected exception during in operator call.");
    }

    public void op_abs() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.abs());
    }

    public void op_add() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getOpStack().push(pSObject2.add(pSObject));
    }

    public void op_aload() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        for (PSObject pSObject2 : pSObject.toArray()) {
            this.getOpStack().push(pSObject2);
        }
        this.getOpStack().push(pSObject);
    }

    public void op_anchorsearch() throws PSError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        PSObjectString pSObjectString2 = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        String string = pSObjectString.toString();
        List<PSObject> list = pSObjectString2.anchorsearch(string);
        while (!list.isEmpty()) {
            this.getOpStack().push(list.remove(0));
        }
    }

    public void op_and() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getOpStack().push(pSObject2.and(pSObject));
    }

    public void op_arc() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        this.gstate.current().arc(d5, d4, d3, d2, d, true);
    }

    public void op_arcn() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toNonNegReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        this.gstate.current().arc(d5, d4, d3, d2, d, false);
    }

    public void op_arct() throws PSError {
        double d = this.getOpStack().pop().toNonNegReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        this.gstate.current().arcto(d5, d4, d3, d2, d);
    }

    public void op_arcto() throws PSError {
        double d = this.getOpStack().pop().toNonNegReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        double[] dArray = this.gstate.current().arcto(d5, d4, d3, d2, d);
        for (int i = 0; i < dArray.length; ++i) {
            this.getOpStack().push(new PSObjectReal(dArray[i]));
        }
    }

    public void op_array() throws PSErrorStackUnderflow, PSErrorTypeCheck, PSErrorRangeCheck {
        int n = this.getOpStack().pop().toNonNegInt();
        this.op_sqBrackLeft();
        PSObjectNull pSObjectNull = new PSObjectNull();
        for (int i = 0; i < n; ++i) {
            this.getOpStack().push(pSObjectNull);
        }
        try {
            this.op_sqBrackRight();
        }
        catch (PSErrorUnmatchedMark pSErrorUnmatchedMark) {
            // empty catch block
        }
    }

    public void op_ashow() throws PSError, IOException, ProgramError {
        this.log.info("ashow operator encoutered. ashow is not implemented, instead the normal show is used.");
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        this.getOpStack().pop().toReal();
        this.getOpStack().pop().toReal();
        this.getOpStack().push(pSObjectString);
        this.op_show();
    }

    public void op_astore() throws PSError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toArray();
        pSObjectArray.checkAccess(false, true, true);
        int n = pSObjectArray.size();
        try {
            for (int i = n - 1; i >= 0; --i) {
                pSObjectArray.set(i, this.getOpStack().pop());
            }
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
        this.getOpStack().push(pSObjectArray);
    }

    public void op_atan() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = Math.atan2(d2, d) / Math.PI * 180.0;
        d3 = (d3 + 360.0) % 360.0;
        this.getOpStack().push(new PSObjectReal(d3));
    }

    public void op_begin() throws PSError {
        PSObjectDict pSObjectDict = this.getOpStack().pop().toDict();
        pSObjectDict.checkAccess(true, true, false);
        this.getDictStack().pushDict(pSObjectDict);
    }

    public void op_bind() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        this.getOpStack().peek().toArray().bind(this);
    }

    public void op_bitshift() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        int n = this.getOpStack().pop().toInt();
        int n2 = this.getOpStack().pop().toInt();
        n2 = n >= 0 ? (n2 <<= n) : (n2 >>>= -n);
        this.getOpStack().push(new PSObjectInt(n2));
    }

    public void op_ceiling() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.ceiling());
    }

    public void op_charpath() throws PSError, ProgramError {
        this.getOpStack().pop().toBool();
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        this.textHandler.charpath(pSObjectString);
    }

    public void op_clear() {
        this.getOpStack().clear();
    }

    public void op_cleardictstack() {
        this.getDictStack().cleardictstack();
    }

    public void op_cleartomark() throws PSErrorUnmatchedMark, PSErrorStackUnderflow {
        int n = this.getOpStack().size();
        for (int i = 0; i < n; ++i) {
            if (!(this.getOpStack().pop() instanceof PSObjectMark)) continue;
            return;
        }
        throw new PSErrorUnmatchedMark();
    }

    public void op_clip() throws PSErrorUnimplemented, IOException {
        this.gstate.current().clip();
        this.gstate.current().getDevice().clip(this.gstate.current().getClippingPath());
    }

    public void op_clippath() {
        this.gstate.current().setPath(this.gstate.current().getClippingPath().clone());
    }

    public void op_cliprestore() throws PSErrorUnimplemented {
        throw new PSErrorUnimplemented("PostScript operator 'cliprestore'");
    }

    public void op_clipsave() throws PSErrorUnimplemented {
        throw new PSErrorUnimplemented("PostScript operator 'clipsave'");
    }

    public void op_closefile() throws PSError {
        PSObjectFile pSObjectFile = this.getOpStack().pop().toFile();
        pSObjectFile.closeFile();
    }

    public void op_closepath() throws PSErrorRangeCheck, PSErrorTypeCheck {
        double[] dArray = this.gstate.current().getPath().closepath();
        if (dArray != null) {
            this.gstate.current().moveto(dArray[0], dArray[1]);
        }
    }

    public void op_colorimage() throws PSError, ProgramError, IOException {
        PSObject pSObject;
        int n;
        PSObject[] pSObjectArray;
        PSColor pSColor;
        int n2 = this.getOpStack().pop().toInt();
        if (n2 == 1) {
            pSColor = new DeviceGray();
        } else if (n2 == 3) {
            pSColor = new DeviceRGB();
        } else if (n2 == 4) {
            pSColor = new DeviceCMYK();
        } else {
            throw new PSErrorRangeCheck();
        }
        boolean bl = this.getOpStack().pop().toBool();
        if (bl) {
            pSObjectArray = new PSObject[n2];
            for (n = n2 - 1; n >= 0; ++n) {
                pSObjectArray[n] = this.getOpStack().pop();
            }
            pSObject = new PSObjectArray(pSObjectArray);
        } else {
            pSObject = this.getOpStack().pop();
        }
        pSObjectArray = this.getOpStack().pop().toMatrix();
        n = this.getOpStack().pop().toInt();
        int n3 = this.getOpStack().pop().toInt();
        int n4 = this.getOpStack().pop().toInt();
        PSObjectDict pSObjectDict = new PSObjectDict();
        pSObjectDict.setKey((PSObject)Image.IMAGE_TYPE, (PSObject)new PSObjectInt(1));
        pSObjectDict.setKey((PSObject)Image.WIDTH, (PSObject)new PSObjectInt(n4));
        pSObjectDict.setKey((PSObject)Image.HEIGHT, (PSObject)new PSObjectInt(n3));
        pSObjectDict.setKey((PSObject)Image.IMAGE_MATRIX, (PSObject)pSObjectArray);
        pSObjectDict.setKey((PSObject)Image.DATA_SOURCE, pSObject);
        pSObjectDict.setKey((PSObject)Image.BITS_PER_COMPONENT, (PSObject)new PSObjectInt(n));
        double[] dArray = new double[2 * n2];
        for (int i = 0; i < n2; ++i) {
            dArray[2 * i] = 0.0;
            dArray[2 * i + 1] = 1.0;
        }
        pSObjectDict.setKey((PSObject)Image.DECODE, (PSObject)new PSObjectArray(dArray));
        Image image = new Image(pSObjectDict, this, pSColor);
        this.gstate.current().getDevice().image(image);
    }

    public void op_concat() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        this.gstate.current().getCtm().concat(pSObjectMatrix);
        this.gstate.current().updatePosition();
    }

    public void op_concatmatrix() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        PSObjectMatrix pSObjectMatrix2 = this.getOpStack().pop().toMatrix();
        PSObjectMatrix pSObjectMatrix3 = this.getOpStack().pop().toMatrix();
        pSObjectMatrix.copy(pSObjectMatrix2);
        pSObjectMatrix.concat(pSObjectMatrix3);
        this.getOpStack().push(pSObjectMatrix);
    }

    public void op_copy() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        if (pSObject instanceof PSObjectInt) {
            int n = pSObject.toNonNegInt();
            int n2 = this.getOpStack().size();
            for (int i = n2 - n; i < n2; ++i) {
                this.getOpStack().push((PSObject)this.getOpStack().get(i));
            }
        } else {
            PSObject pSObject2 = this.getOpStack().pop();
            pSObject.checkAccess(false, false, true);
            pSObject2.checkAccess(false, true, false);
            PSObject pSObject3 = pSObject.copy(pSObject2);
            this.getOpStack().push(pSObject3);
        }
    }

    public void op_cos() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        this.getOpStack().push(new PSObjectReal(Math.cos(d * Math.PI / 180.0)));
    }

    public void op_count() {
        int n = this.getOpStack().size();
        PSObjectInt pSObjectInt = new PSObjectInt(n);
        this.getOpStack().push(pSObjectInt);
    }

    public void op_countdictstack() {
        this.getOpStack().push(new PSObjectInt(this.getDictStack().countdictstack()));
    }

    public void op_countexecstack() {
        this.getOpStack().push(new PSObjectInt(this.getExecStack().size()));
    }

    public void op_counttomark() throws PSErrorUnmatchedMark {
        int n = this.getOpStack().size();
        for (int i = n - 1; i >= 0; --i) {
            if (!(this.getOpStack().get(i) instanceof PSObjectMark)) continue;
            this.getOpStack().push(new PSObjectInt(n - 1 - i));
            return;
        }
        throw new PSErrorUnmatchedMark();
    }

    public void op_currentcmykcolor() throws PSError, ProgramError {
        double[] dArray = this.gstate.current().currentcmykcolor();
        for (int i = 0; i < dArray.length; ++i) {
            this.getOpStack().push(new PSObjectReal(dArray[i]));
        }
    }

    public void op_currentcolor() {
        PSColor pSColor = this.gstate.current().getColor();
        for (int i = 0; i < pSColor.getNrComponents(); ++i) {
            this.getOpStack().push(new PSObjectReal(pSColor.getLevel(i)));
        }
    }

    public void op_currentcolorspace() {
        this.getOpStack().push(this.gstate.current().getColor().getColorSpace());
    }

    public void op_currentdict() {
        this.getOpStack().push(this.getDictStack().peekDict());
    }

    public void op_currentdash() {
        this.opStack.push(this.gstate.current().getDashPattern().clone());
        this.opStack.push(new PSObjectReal(this.gstate.current().getDashOffset()));
    }

    public void op_currentfile() throws PSError {
        PSObjectFile pSObjectFile = this.getExecStack().getTopmostFile();
        pSObjectFile = pSObjectFile == null ? new PSObjectFile(null) : pSObjectFile.dup();
        pSObjectFile.cvlit();
        this.getOpStack().push(pSObjectFile);
    }

    public void op_currentflat() {
        this.getOpStack().push(new PSObjectReal(0.2));
    }

    public void op_currentgray() throws PSError, ProgramError {
        double d = this.gstate.current().currentgray();
        this.getOpStack().push(new PSObjectReal(d));
    }

    public void op_currenthsbcolor() throws PSError, ProgramError {
        double[] dArray = this.gstate.current().currenthsbcolor();
        for (int i = 0; i < dArray.length; ++i) {
            this.getOpStack().push(new PSObjectReal(dArray[i]));
        }
    }

    public void op_currentlinewidth() {
        this.getOpStack().push(new PSObjectReal(this.gstate.current().getLineWidth()));
    }

    public void op_currentmatrix() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        pSObjectMatrix.copy(this.gstate.current().getCtm());
        this.getOpStack().push(pSObjectMatrix);
    }

    public void op_currentpoint() throws PSError {
        double[] dArray = this.gstate.current().getCurrentPosInDeviceSpace();
        double[] dArray2 = this.gstate.current().getCtm().itransform(dArray);
        this.getOpStack().push(new PSObjectReal(dArray2[0]));
        this.getOpStack().push(new PSObjectReal(dArray2[1]));
    }

    public void op_currentrgbcolor() throws PSError, ProgramError {
        double[] dArray = this.gstate.current().currentrgbcolor();
        for (int i = 0; i < dArray.length; ++i) {
            this.getOpStack().push(new PSObjectReal(dArray[i]));
        }
    }

    public void op_currentscreen() throws PSError, ProgramError {
        this.getOpStack().push(new PSObjectReal(150.0));
        this.getOpStack().push(new PSObjectReal(45.0));
        try {
            String string = "{ 180 mul cos exch 180 mul cos add 2 div }";
            this.getOpStack().push(Parser.convertToPSObject(string));
        }
        catch (PSErrorIOError pSErrorIOError) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void op_currentstrokeadjust() {
        this.getOpStack().push(new PSObjectBool(this.gstate.current().getStrokeAdjust()));
    }

    public void op_curveto() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        double d6 = this.getOpStack().pop().toReal();
        this.gstate.current().curveto(d6, d5, d4, d3, d2, d);
    }

    public void op_cvi() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        this.getOpStack().push(new PSObjectInt(pSObject.cvi()));
    }

    public void op_cvlit() throws PSErrorStackUnderflow, PSErrorUnimplemented {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.cvlit());
    }

    public void op_cvn() throws PSError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        this.getOpStack().push(pSObjectString.cvn());
    }

    public void op_cvr() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        this.getOpStack().push(new PSObjectReal(pSObject.cvr()));
    }

    public void op_cvrs() throws PSError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, false, true);
        int n = this.getOpStack().pop().toInt();
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(new PSObjectString(pSObject.cvrs(n)));
    }

    public void op_cvs() throws PSError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        PSObject pSObject = this.getOpStack().pop();
        pSObjectString.checkAccess(false, false, true);
        pSObject.checkAccess(false, true, false);
        pSObjectString.overwrite(pSObject.cvs());
        this.getOpStack().push(pSObjectString);
    }

    public void op_cvx() throws PSErrorStackUnderflow {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.cvx());
    }

    public void op_dblGreaterBrackets() throws PSError, IOException, ProgramError {
        PSObjectArray pSObjectArray = new PSObjectArray("{def}");
        this.op_counttomark();
        this.getOpStack().push(new PSObjectInt(2));
        this.op_idiv();
        this.op_dup();
        this.op_dict();
        this.op_begin();
        this.getOpStack().push(pSObjectArray);
        this.op_repeat();
        this.op_pop();
        this.op_currentdict();
        this.op_end();
    }

    public void op_dblLessBrackets() {
        this.op_mark();
    }

    public void op_def() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getDictStack().checkAccess(false, false, true);
        this.getDictStack().def(pSObject2, pSObject);
    }

    public void op_defaultmatrix() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        pSObjectMatrix.copy(this.gstate.current().getDevice().defaultCTM());
        this.getOpStack().push(pSObjectMatrix);
    }

    public void op_definefont() throws PSError, ProgramError {
        PSObjectFont pSObjectFont = this.getOpStack().pop().toFont();
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.resourceManager.defineResource(ResourceManager.CAT_FONT, pSObject, pSObjectFont);
        this.getOpStack().push(pSObject2);
    }

    public void op_defineresource() throws PSError, ProgramError {
        PSObjectName pSObjectName = this.getOpStack().pop().toName();
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        PSObject pSObject3 = this.resourceManager.defineResource(pSObjectName, pSObject2, pSObject);
        this.getOpStack().push(pSObject3);
    }

    public void op_dict() throws PSErrorStackUnderflow, PSErrorTypeCheck, PSErrorRangeCheck {
        int n = this.getOpStack().pop().toNonNegInt();
        this.getOpStack().push(new PSObjectDict(n));
    }

    public void op_dictstack() throws PSError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toArray();
        pSObjectArray.checkAccess(false, false, true);
        this.getOpStack().push(this.getDictStack().dictstack(pSObjectArray));
    }

    public void op_div() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        this.getOpStack().push(new PSObjectReal(d2 / d));
    }

    public void op_dtransform() throws PSError {
        double d;
        PSObject pSObject = this.getOpStack().pop();
        PSObjectMatrix pSObjectMatrix = null;
        try {
            pSObjectMatrix = pSObject.toMatrix();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
        if (pSObjectMatrix == null) {
            pSObjectMatrix = this.gstate.current().getCtm();
            d = pSObject.toReal();
        } else {
            d = this.getOpStack().pop().toReal();
        }
        double d2 = this.getOpStack().pop().toReal();
        double[] dArray = pSObjectMatrix.dtransform(d2, d);
        this.getOpStack().push(new PSObjectReal(dArray[0]));
        this.getOpStack().push(new PSObjectReal(dArray[1]));
    }

    public void op_dup() throws PSErrorStackUnderflow {
        this.getOpStack().push(this.getOpStack().peek().dup());
    }

    public void op_eexec() throws PSError, ProgramError {
        InputStream inputStream;
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(true, false, false);
        if (pSObject instanceof PSObjectFile) {
            inputStream = ((PSObjectFile)pSObject).getStream();
        } else if (pSObject instanceof PSObjectString) {
            inputStream = new PSStringInputStream((PSObjectString)pSObject);
        } else {
            throw new PSErrorTypeCheck();
        }
        EexecDecode eexecDecode = new EexecDecode(inputStream);
        PSObjectFile pSObjectFile = new PSObjectFile(eexecDecode);
        this.getOpStack().push(this.getDictStack().lookup("systemdict"));
        this.op_begin();
        this.runObject(pSObjectFile);
        this.op_end();
    }

    public void op_end() throws PSErrorDictStackUnderflow {
        this.getDictStack().popDict();
    }

    public void op_eoclip() throws PSError, IOException {
        this.gstate.current().clip();
        this.gstate.current().getDevice().eoclip(this.gstate.current());
    }

    public void op_eofill() throws PSError, IOException, ProgramError {
        this.gstate.current().getDevice().eofill(this.gstate.current());
        this.op_newpath();
    }

    public void op_eps2pgfgetmetrics() {
        double[] dArray = this.gstate.current().getDevice().eps2pgfGetMetrics();
        PSObjectArray pSObjectArray = new PSObjectArray(dArray);
        this.getOpStack().push(pSObjectArray);
    }

    public void op_errordict() throws PSErrorUnimplemented {
        throw new PSErrorUnimplemented("errordict operator");
    }

    public void op_eq() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        PSObject pSObject2 = this.getOpStack().pop();
        pSObject2.checkAccess(false, true, false);
        this.getOpStack().push(new PSObjectBool(pSObject2.eq(pSObject)));
    }

    public void op_exch() throws PSErrorStackUnderflow {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getOpStack().push(pSObject);
        this.getOpStack().push(pSObject2);
    }

    public void op_exec() throws PSError, ProgramError {
        PSObject pSObject = this.getOpStack().pop();
        this.executeObject(pSObject);
    }

    public void op_execstack() throws PSError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toArray();
        pSObjectArray.checkAccess(false, false, true);
        PSObject pSObject = pSObjectArray.copy(this.getExecStack().getStack());
        this.getOpStack().push(pSObject);
    }

    public void op_executeonly() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(true, false, false);
        pSObject.executeonly();
        this.getOpStack().push(pSObject);
    }

    public void op_exit() throws PSErrorInvalidExit {
        throw new PSErrorInvalidExit();
    }

    public void op_exp() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = Math.pow(d2, d);
        this.getOpStack().push(new PSObjectReal(d3));
    }

    public void op_false() {
        this.getOpStack().push(new PSObjectBool(false));
    }

    public void op_fill() throws PSError, IOException, ProgramError {
        this.gstate.current().getDevice().fill(this.gstate.current());
        this.op_newpath();
    }

    public void op_filter() throws PSError {
        PSObjectName pSObjectName = this.getOpStack().pop().toName();
        PSObjectDict pSObjectDict = FilterManager.getParameters(pSObjectName, this.getOpStack());
        PSObject pSObject = this.getOpStack().pop();
        PSObjectFile pSObjectFile = FilterManager.filter(pSObjectName, pSObjectDict, pSObject);
        this.getOpStack().push(pSObjectFile);
    }

    public void op_findfont() throws PSError, ProgramError {
        PSObject pSObject = this.getOpStack().pop();
        FontManager fontManager = this.resourceManager.getFontManager();
        this.getOpStack().push(fontManager.findFont(pSObject));
    }

    public void op_findresource() throws PSError, ProgramError {
        PSObjectName pSObjectName = this.getOpStack().pop().toName();
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.resourceManager.findResource(pSObjectName, pSObject);
        this.getOpStack().push(pSObject2);
    }

    public void op_flattenpath() throws PSError, ProgramError {
        this.gstate.current().flattenpath();
    }

    public void op_floor() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.floor());
    }

    public void op_flushfile() throws PSError {
        PSObjectFile pSObjectFile = this.getOpStack().pop().toFile();
        pSObjectFile.flushFile();
    }

    public void op_for() throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toProc();
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        boolean bl = false;
        if (d == (double)Math.round(d) && d2 == (double)Math.round(d2) && d3 == (double)Math.round(d3)) {
            bl = true;
        }
        if (d2 == 0.0) {
            return;
        }
        if (d2 > 0.0 && d < d3) {
            return;
        }
        if (d2 < 0.0 && d > d3) {
            return;
        }
        try {
            for (double d4 = d3; !(d2 > 0.0 && d4 > d || d2 < 0.0 && d4 < d); d4 += d2) {
                if (bl) {
                    this.getOpStack().push(new PSObjectInt(d4));
                } else {
                    this.getOpStack().push(new PSObjectReal(d4));
                }
                this.runObject(pSObjectArray);
            }
        }
        catch (PSErrorInvalidExit pSErrorInvalidExit) {
            // empty catch block
        }
    }

    public void op_forall() throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toProc();
        pSObjectArray.checkAccess(true, false, false);
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        List<PSObject> list = pSObject.getItemList();
        int n = list.remove(0).toNonNegInt();
        try {
            while (!list.isEmpty()) {
                for (int i = 0; i < n; ++i) {
                    this.getOpStack().push(list.remove(0));
                }
                this.runObject(pSObjectArray);
            }
        }
        catch (PSErrorInvalidExit pSErrorInvalidExit) {
            // empty catch block
        }
    }

    public void op_ge() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        PSObject pSObject2 = this.getOpStack().pop();
        pSObject2.checkAccess(false, true, false);
        boolean bl = pSObject2.gt(pSObject);
        boolean bl2 = pSObject2.eq(pSObject);
        this.getOpStack().push(new PSObjectBool(bl || bl2));
    }

    public void op_get() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        pSObject2.checkAccess(false, true, false);
        this.getOpStack().push(pSObject2.get(pSObject));
    }

    public void op_getinterval() throws PSError {
        int n = this.getOpStack().pop().toNonNegInt();
        int n2 = this.getOpStack().pop().toNonNegInt();
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        this.getOpStack().push(pSObject.getinterval(n2, n));
    }

    public void op_grestore() throws PSError, IOException, ProgramError {
        this.gstate.restoreGstate();
    }

    public void op_gsave() throws PSError, IOException, ProgramError {
        this.gstate.saveGstate();
    }

    public void op_gt() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        PSObject pSObject2 = this.getOpStack().pop();
        pSObject2.checkAccess(false, true, false);
        boolean bl = pSObject2.gt(pSObject);
        this.getOpStack().push(new PSObjectBool(bl));
    }

    public void op_identmatrix() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        pSObjectMatrix.copy(new PSObjectMatrix());
        this.getOpStack().push(pSObjectMatrix);
    }

    public void op_idiv() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        int n = this.getOpStack().pop().toInt();
        int n2 = this.getOpStack().pop().toInt();
        int n3 = n2 / n;
        this.getOpStack().push(new PSObjectInt(n3));
    }

    public void op_idtransform() throws PSError {
        double d;
        PSObject pSObject = this.getOpStack().pop();
        PSObjectMatrix pSObjectMatrix = null;
        try {
            pSObjectMatrix = pSObject.toMatrix();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
        if (pSObjectMatrix == null) {
            pSObjectMatrix = this.gstate.current().getCtm();
            d = pSObject.toReal();
        } else {
            d = this.getOpStack().pop().toReal();
        }
        double d2 = this.getOpStack().pop().toReal();
        double[] dArray = pSObjectMatrix.idtransform(d2, d);
        this.getOpStack().push(new PSObjectReal(dArray[0]));
        this.getOpStack().push(new PSObjectReal(dArray[1]));
    }

    public void op_if() throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toProc();
        boolean bl = this.getOpStack().pop().toBool();
        if (bl) {
            this.runObject(pSObjectArray);
        }
    }

    public void op_ifelse() throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toProc();
        PSObjectArray pSObjectArray2 = this.getOpStack().pop().toProc();
        boolean bl = this.getOpStack().pop().toBool();
        if (bl) {
            this.runObject(pSObjectArray2);
        } else {
            this.runObject(pSObjectArray);
        }
    }

    public void op_image() throws PSError, ProgramError, IOException {
        Object object;
        PSColor pSColor;
        PSObjectDict pSObjectDict;
        PSObject pSObject = this.getOpStack().pop();
        if (pSObject instanceof PSObjectDict) {
            pSObjectDict = pSObject.toDict();
            pSColor = this.gstate.current().getColor();
        } else {
            object = this.getOpStack().pop().toMatrix();
            int n = this.getOpStack().pop().toInt();
            int n2 = this.getOpStack().pop().toInt();
            int n3 = this.getOpStack().pop().toInt();
            pSObjectDict = new PSObjectDict();
            pSObjectDict.setKey((PSObject)Image.IMAGE_TYPE, (PSObject)new PSObjectInt(1));
            pSObjectDict.setKey((PSObject)Image.WIDTH, (PSObject)new PSObjectInt(n3));
            pSObjectDict.setKey((PSObject)Image.HEIGHT, (PSObject)new PSObjectInt(n2));
            pSObjectDict.setKey((PSObject)Image.IMAGE_MATRIX, (PSObject)object);
            pSObjectDict.setKey((PSObject)Image.DATA_SOURCE, pSObject);
            pSObjectDict.setKey((PSObject)Image.BITS_PER_COMPONENT, (PSObject)new PSObjectInt(n));
            double[] dArray = new double[]{0.0, 1.0};
            pSObjectDict.setKey((PSObject)Image.DECODE, (PSObject)new PSObjectArray(dArray));
            pSColor = new DeviceGray();
        }
        object = new Image(pSObjectDict, this, pSColor);
        this.gstate.current().getDevice().image((Image)object);
    }

    public void op_index() throws PSError {
        int n = this.getOpStack().pop().toNonNegInt();
        this.getOpStack().push(this.getOpStack().peek(n));
    }

    public void op_invertmatrix() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        PSObjectMatrix pSObjectMatrix2 = this.getOpStack().pop().toMatrix();
        pSObjectMatrix.copy(pSObjectMatrix2);
        pSObjectMatrix.invert();
        this.getOpStack().push(pSObjectMatrix);
    }

    public void op_initclip() throws IOException, PSErrorUnimplemented {
        this.gstate.current().setClippingPath(this.defaultClippingPath.clone());
        this.gstate.current().getDevice().clip(this.gstate.current().getClippingPath());
    }

    public void op_initmatrix() {
        this.gstate.current().initmatrix();
    }

    public void op_isis() throws PSErrorStackUnderflow {
        PSObject pSObject = this.opStack.pop();
        System.out.println(pSObject.isis());
    }

    public void op_itransform() throws PSError {
        double d;
        PSObject pSObject = this.getOpStack().pop();
        PSObjectMatrix pSObjectMatrix = null;
        try {
            pSObjectMatrix = pSObject.toMatrix();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
        if (pSObjectMatrix == null) {
            pSObjectMatrix = this.gstate.current().getCtm();
            d = pSObject.toReal();
        } else {
            d = this.getOpStack().pop().toReal();
        }
        double d2 = this.getOpStack().pop().toReal();
        double[] dArray = pSObjectMatrix.itransform(d2, d);
        this.getOpStack().push(new PSObjectReal(dArray[0]));
        this.getOpStack().push(new PSObjectReal(dArray[1]));
    }

    public void op_known() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObjectDict pSObjectDict = this.getOpStack().pop().toDict();
        pSObjectDict.checkAccess(false, true, false);
        this.getOpStack().push(new PSObjectBool(pSObjectDict.known(pSObject)));
    }

    public void op_le() throws PSError {
        this.op_gt();
        this.op_not();
    }

    public void op_length() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        this.getOpStack().push(new PSObjectInt(pSObject.length()));
    }

    public void op_lineto() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        this.gstate.current().lineto(d2, d);
    }

    public void op_ln() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        double d2 = Math.log(d);
        this.getOpStack().push(new PSObjectReal(d2));
    }

    public void op_load() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObjectDict pSObjectDict = this.getDictStack().where(pSObject);
        if (pSObjectDict == null) {
            throw new PSErrorUndefined("--load-- (" + pSObject.isis() + ")");
        }
        pSObjectDict.checkAccess(false, true, false);
        PSObject pSObject2 = this.getDictStack().lookup(pSObject);
        if (pSObject2 == null) {
            this.getOpStack().push(new PSObjectName("/" + pSObject));
            throw new PSErrorUndefined();
        }
        this.getOpStack().push(pSObject2);
    }

    public void op_log() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        double d2 = Math.log10(d);
        this.getOpStack().push(new PSObjectReal(d2));
    }

    public void op_loop() throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toProc();
        try {
            while (true) {
                this.runObject(pSObjectArray);
            }
        }
        catch (PSErrorInvalidExit pSErrorInvalidExit) {
        }
        catch (PSErrorInvalidStop pSErrorInvalidStop) {
            // empty catch block
        }
    }

    public void op_lt() throws PSError {
        this.op_ge();
        this.op_not();
    }

    public void op_makefont() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        PSObjectDict pSObjectDict = this.getOpStack().pop().toDict();
        pSObjectDict = pSObjectDict.clone();
        PSObjectMatrix pSObjectMatrix2 = pSObjectDict.lookup("FontMatrix").toMatrix();
        pSObjectMatrix2.concat(pSObjectMatrix);
        pSObjectDict.setKey("FontMatrix", (PSObject)pSObjectMatrix2);
        PSObjectMatrix pSObjectMatrix3 = this.gstate.current().getCtm().clone();
        pSObjectMatrix3.concat(pSObjectMatrix2);
        double d = pSObjectMatrix3.getMeanScaling() / 2.54 * 72.27;
        pSObjectDict.setKey("FontSize", (PSObject)new PSObjectReal(d));
        this.getOpStack().push(pSObjectDict);
    }

    public void op_mark() {
        this.getOpStack().push(new PSObjectMark());
    }

    public void op_matrix() throws PSError {
        this.getOpStack().push(new PSObjectMatrix());
    }

    public void op_maxlength() throws PSError {
        PSObjectDict pSObjectDict = this.getOpStack().pop().toDict();
        pSObjectDict.checkAccess(false, true, false);
        this.getOpStack().push(new PSObjectInt(pSObjectDict.maxlength()));
    }

    public void op_mod() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        int n = this.getOpStack().pop().toInt();
        int n2 = this.getOpStack().pop().toInt();
        this.getOpStack().push(new PSObjectInt(n2 % n));
    }

    public void op_moveto() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        this.gstate.current().moveto(d2, d);
    }

    public void op_mul() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getOpStack().push(pSObject2.mul(pSObject));
    }

    public void op_ne() throws PSError {
        this.op_eq();
        this.op_not();
    }

    public void op_neg() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.neg());
    }

    public void op_newpath() {
        this.gstate.current().setPath(new Path(this.gstate));
        this.gstate.current().setPosition(Double.NaN, Double.NaN);
    }

    public void op_noaccess() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        if (pSObject instanceof PSObjectDict) {
            pSObject.checkAccess(false, false, true);
        }
        pSObject.noaccess();
        this.getOpStack().push(pSObject);
    }

    public void op_not() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.not());
    }

    public void op_null() throws PSError {
        this.getOpStack().push(new PSObjectNull());
    }

    public void op_nulldevice() {
        NullDevice nullDevice = new NullDevice();
        this.gstate.current().setDevice(nullDevice);
        this.gstate.current().initmatrix();
    }

    public void op_or() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getOpStack().push(pSObject2.or(pSObject));
    }

    public void op_pathbbox() throws PSError {
        double[] dArray = this.gstate.current().pathbbox();
        for (int i = 0; i < 4; ++i) {
            this.getOpStack().push(new PSObjectReal(dArray[i]));
        }
    }

    public void op_pathforall() throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toProc();
        PSObjectArray pSObjectArray2 = this.getOpStack().pop().toProc();
        PSObjectArray pSObjectArray3 = this.getOpStack().pop().toProc();
        PSObjectArray pSObjectArray4 = this.getOpStack().pop().toProc();
        ArrayList<PathSection> arrayList = this.gstate.current().getPath().getSections();
        PSObjectMatrix pSObjectMatrix = this.gstate.current().getCtm();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                PathSection pathSection = arrayList.get(i);
                int n = 0;
                PSObjectArray pSObjectArray5 = pSObjectArray;
                if (pathSection instanceof Moveto) {
                    n = 1;
                    pSObjectArray5 = pSObjectArray4;
                } else if (pathSection instanceof Lineto) {
                    n = 1;
                    pSObjectArray5 = pSObjectArray3;
                } else if (pathSection instanceof Curveto) {
                    n = 3;
                    pSObjectArray5 = pSObjectArray2;
                }
                for (int j = 0; j < n; ++j) {
                    double d = pathSection.getParam(2 * j);
                    double d2 = pathSection.getParam(2 * j + 1);
                    double[] dArray = pSObjectMatrix.itransform(d, d2);
                    this.getOpStack().push(new PSObjectReal(dArray[0]));
                    this.getOpStack().push(new PSObjectReal(dArray[1]));
                }
                this.runObject(pSObjectArray5);
            }
        }
        catch (PSErrorInvalidExit pSErrorInvalidExit) {
            // empty catch block
        }
    }

    public void op_picstr() throws PSError {
        throw new PSErrorUnimplemented("operator: picstr");
    }

    public void op_pop() throws PSErrorStackUnderflow {
        this.getOpStack().pop();
    }

    public void op_product() {
        this.getOpStack().push(new PSObjectString("Eps2pgf"));
    }

    public void op_pstack() {
        for (int i = this.getOpStack().size() - 1; i >= 0; --i) {
            System.out.println(((PSObject)this.getOpStack().get(i)).isis());
        }
    }

    public void op_put() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        PSObject pSObject3 = this.getOpStack().pop();
        pSObject3.checkAccess(false, false, true);
        pSObject3.put(pSObject2, pSObject);
    }

    public void op_putinterval() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        int n = this.getOpStack().pop().toNonNegInt();
        PSObject pSObject2 = this.getOpStack().pop();
        pSObject2.checkAccess(false, false, true);
        pSObject2.putinterval(n, pSObject);
    }

    public void op_quit() throws PSError {
        throw new QuitOpExecuted();
    }

    public void op_rcheck() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        boolean bl = pSObject.rcheck();
        this.getOpStack().push(new PSObjectBool(bl));
    }

    public void op_rcurveto() throws PSErrorStackUnderflow, PSErrorTypeCheck, PSErrorRangeCheck {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        double d6 = this.getOpStack().pop().toReal();
        this.gstate.current().rcurveto(d6, d5, d4, d3, d2, d);
    }

    public void op_readhexstring() throws PSError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        if (pSObjectString.length() == 0) {
            throw new PSErrorRangeCheck();
        }
        PSObject pSObject = this.getOpStack().peek();
        if (!(pSObject instanceof PSObjectFile)) {
            throw new PSErrorTypeCheck();
        }
        pSObject.checkAccess(false, false, true);
        this.getOpStack().push(new PSObjectName("/ASCIIHexDecode"));
        this.op_filter();
        PSObjectFile pSObjectFile = this.getOpStack().pop().toFile();
        PSObjectString pSObjectString2 = pSObjectFile.readstring(pSObjectString);
        boolean bl = pSObjectString.length() == pSObjectString2.length();
        this.getOpStack().push(pSObjectString2);
        this.getOpStack().push(new PSObjectBool(bl));
    }

    public void op_readonly() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        pSObject.readonly();
        this.getOpStack().push(pSObject);
    }

    public void op_readstring() throws PSError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        if (pSObjectString.length() == 0) {
            throw new PSErrorRangeCheck();
        }
        PSObjectFile pSObjectFile = this.getOpStack().pop().toFile();
        pSObjectFile.checkAccess(false, false, true);
        PSObjectString pSObjectString2 = pSObjectFile.readstring(pSObjectString);
        boolean bl = pSObjectString.length() == pSObjectString2.length();
        this.getOpStack().push(pSObjectString2);
        this.getOpStack().push(new PSObjectBool(bl));
    }

    public void op_realtime() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(11);
        n = 60 * n + calendar.get(12);
        n = 60 * n + calendar.get(13);
        n = 1000 * n + calendar.get(14);
        this.getOpStack().push(new PSObjectInt(n));
    }

    public void op_rectclip() throws PSError, IOException {
        this.rectPath();
        this.op_clip();
        this.op_newpath();
    }

    public void op_rectfill() throws PSError, IOException, ProgramError {
        this.op_gsave();
        this.rectPath();
        this.op_fill();
        this.op_grestore();
    }

    public void op_rectstroke() throws PSError, ProgramError, IOException {
        this.op_gsave();
        PSObjectMatrix pSObjectMatrix = null;
        try {
            pSObjectMatrix = this.getOpStack().peek().toMatrix();
            this.getOpStack().pop();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
        this.rectPath();
        if (pSObjectMatrix != null) {
            this.getOpStack().push(pSObjectMatrix);
            this.op_concat();
        }
        this.op_stroke();
        this.op_grestore();
    }

    public void op_repeat() throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.getOpStack().pop().toProc();
        int n = this.getOpStack().pop().toNonNegInt();
        try {
            for (int i = 0; i < n; ++i) {
                this.runObject(pSObjectArray);
            }
        }
        catch (PSErrorInvalidExit pSErrorInvalidExit) {
            // empty catch block
        }
    }

    public void op_resourcestatus() throws PSError {
        PSObjectName pSObjectName = this.getOpStack().pop().toName();
        PSObject pSObject = this.getOpStack().pop();
        PSObjectArray pSObjectArray = this.resourceManager.resourceStatus(pSObjectName, pSObject);
        for (int i = 0; i < pSObjectArray.size(); ++i) {
            this.getOpStack().push(pSObjectArray.get(i));
        }
    }

    public void op_restore() throws PSError, IOException, ProgramError {
        PSObjectName pSObjectName = this.getOpStack().pop().toName();
        if (!pSObjectName.toString().equals("-save- (dummy)")) {
            throw new PSErrorTypeCheck();
        }
        this.op_grestore();
    }

    public void op_rlineto() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        this.gstate.current().rlineto(d2, d);
    }

    public void op_rmoveto() throws PSError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        this.gstate.current().rmoveto(d2, d);
    }

    public void op_roll() throws PSError {
        int n;
        int n2 = this.getOpStack().pop().toInt();
        int n3 = this.getOpStack().pop().toNonNegInt();
        if (n3 == 0) {
            return;
        }
        PSObject[] pSObjectArray = new PSObject[n3];
        for (int i = n3 - 1; i >= 0; --i) {
            pSObjectArray[i] = this.getOpStack().pop();
        }
        if ((n2 %= n3) < 0) {
            n2 += n3;
        }
        PSObject[] pSObjectArray2 = new PSObject[n3];
        for (n = 0; n < n3; ++n) {
            int n4 = (n + n2) % n3;
            pSObjectArray2[n4] = pSObjectArray[n];
        }
        for (n = 0; n < n3; ++n) {
            this.getOpStack().push(pSObjectArray2[n]);
        }
    }

    public void op_rotate() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        if (pSObject instanceof PSObjectArray) {
            PSObjectMatrix pSObjectMatrix = pSObject.toMatrix();
            double d = this.getOpStack().pop().toReal();
            pSObjectMatrix.rotate(d);
            this.getOpStack().push(pSObjectMatrix);
        } else {
            double d = pSObject.toReal();
            this.gstate.current().getCtm().rotate(d);
            this.gstate.current().updatePosition();
        }
    }

    public void op_round() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.round());
    }

    public void op_save() throws PSError, IOException, ProgramError {
        this.getOpStack().push(new PSObjectName("/-save- (dummy)"));
        this.op_gsave();
    }

    public void op_scale() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        if (pSObject instanceof PSObjectArray) {
            PSObjectMatrix pSObjectMatrix = pSObject.toMatrix();
            double d = this.getOpStack().pop().toReal();
            double d2 = this.getOpStack().pop().toReal();
            pSObjectMatrix.scale(d2, d);
            this.getOpStack().push(pSObjectMatrix);
        } else {
            double d = pSObject.toReal();
            double d3 = this.getOpStack().pop().toReal();
            this.gstate.current().getCtm().scale(d3, d);
            this.gstate.current().updatePosition();
        }
    }

    public void op_scalefont() throws PSError {
        double d = this.getOpStack().pop().toReal();
        this.op_sqBrackLeft();
        this.getOpStack().push(new PSObjectReal(d));
        this.getOpStack().push(new PSObjectReal(0.0));
        this.getOpStack().push(new PSObjectReal(0.0));
        this.getOpStack().push(new PSObjectReal(d));
        this.getOpStack().push(new PSObjectReal(0.0));
        this.getOpStack().push(new PSObjectReal(0.0));
        try {
            this.op_sqBrackRight();
        }
        catch (PSErrorUnmatchedMark pSErrorUnmatchedMark) {
            // empty catch block
        }
        try {
            this.op_makefont();
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
    }

    public void op_search() throws PSError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        PSObjectString pSObjectString2 = this.getOpStack().pop().toPSString();
        pSObjectString2.checkAccess(false, true, false);
        String string = pSObjectString.toString();
        List<PSObject> list = pSObjectString2.search(string);
        while (!list.isEmpty()) {
            this.getOpStack().push(list.remove(0));
        }
    }

    public void op_selectfont() throws PSError, ProgramError {
        PSObject pSObject = this.getOpStack().pop();
        this.op_findfont();
        this.getOpStack().push(pSObject);
        if (pSObject instanceof PSObjectInt || pSObject instanceof PSObjectReal) {
            this.op_scalefont();
        } else if (pSObject instanceof PSObjectArray) {
            this.op_makefont();
        } else {
            throw new PSErrorTypeCheck();
        }
        this.op_setfont();
    }

    public void op_setcachedevice() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        double d6 = this.getOpStack().pop().toReal();
        this.gstate.current().setDevice(new CacheDevice(d6, d5, d4, d3, d2, d));
        this.gstate.current().initmatrix();
    }

    public void op_setcachedevice2() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        this.getOpStack().pop();
        this.getOpStack().pop();
        this.getOpStack().pop();
        this.getOpStack().pop();
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double d5 = this.getOpStack().pop().toReal();
        double d6 = this.getOpStack().pop().toReal();
        this.gstate.current().setDevice(new CacheDevice(d6, d5, d4, d3, d2, d));
        this.gstate.current().initmatrix();
    }

    public void op_setcmykcolor() throws PSError, IOException, ProgramError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double d4 = this.getOpStack().pop().toReal();
        double[] dArray = new double[]{d4, d3, d2, d};
        this.gstate.current().setcolorspace(new PSObjectName("DeviceCMYK", true));
        this.gstate.current().setcolor(dArray);
    }

    public void op_setcolor() throws PSError, IOException, ProgramError {
        int n = this.gstate.current().getColor().getNrInputValues();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[n - i - 1] = this.getOpStack().pop().toReal();
        }
        this.gstate.current().setcolor(dArray);
    }

    public void op_setcolorspace() throws PSError, IOException, ProgramError {
        PSObject pSObject = this.getOpStack().pop();
        this.gstate.current().setcolorspace(pSObject);
    }

    public void op_setdash() throws PSError, IOException {
        double d = this.getOpStack().pop().toReal();
        PSObjectArray pSObjectArray = this.getOpStack().pop().toArray();
        this.gstate.current().setDashPattern(pSObjectArray);
        this.gstate.current().setDashOffset(d);
    }

    public void op_setflat() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        d = Math.max(d, 0.2);
        d = Math.min(d, 100.0);
        this.gstate.current().setFlat(d);
    }

    public void op_setfont() throws PSErrorTypeCheck, PSErrorStackUnderflow {
        PSObjectFont pSObjectFont = this.getOpStack().pop().toFont();
        this.gstate.current().setFont(pSObjectFont);
    }

    public void op_setgray() throws PSError, IOException, ProgramError {
        double[] dArray = new double[]{this.getOpStack().pop().toReal()};
        this.gstate.current().setcolorspace(new PSObjectName("DeviceGray", true));
        this.gstate.current().setcolor(dArray);
    }

    public void op_sethsbcolor() throws PSError, IOException, ProgramError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double[] dArray = DeviceRGB.convertHSBtoRGB(d3, d2, d);
        this.gstate.current().setcolorspace(new PSObjectName("DeviceRGB", true));
        this.gstate.current().setcolor(dArray);
    }

    public void op_setlinecap() throws PSError, IOException {
        int n = this.getOpStack().pop().toNonNegInt();
        this.gstate.current().setLineCap(n);
    }

    public void op_setlinejoin() throws PSError, IOException {
        int n = this.getOpStack().pop().toNonNegInt();
        this.gstate.current().setLineJoin(n);
    }

    public void op_setlinewidth() throws PSError, IOException {
        double d = this.getOpStack().pop().toReal();
        this.gstate.current().setLineWidth(Math.abs(d));
    }

    public void op_setmatrix() throws PSError {
        PSObjectMatrix pSObjectMatrix = this.getOpStack().pop().toMatrix();
        this.gstate.current().getCtm().copy(pSObjectMatrix);
    }

    public void op_setmiterlimit() throws PSErrorStackUnderflow, PSErrorTypeCheck, PSErrorRangeCheck, IOException {
        double d = this.getOpStack().pop().toReal();
        if (d < 1.0) {
            throw new PSErrorRangeCheck();
        }
        this.gstate.current().setMiterLimit(d);
    }

    public void op_setpacking() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        boolean bl = this.getOpStack().pop().toBool();
        PSObjectDict pSObjectDict = this.dictStack.lookup("systemdict").toDict();
        pSObjectDict.setKey("currentpacking", (PSObject)new PSObjectBool(bl));
    }

    public void op_setrgbcolor() throws PSError, IOException, ProgramError {
        double d = this.getOpStack().pop().toReal();
        double d2 = this.getOpStack().pop().toReal();
        double d3 = this.getOpStack().pop().toReal();
        double[] dArray = new double[]{d3, d2, d};
        this.gstate.current().setcolorspace(new PSObjectName("DeviceRGB", true));
        this.gstate.current().setcolor(dArray);
    }

    public void op_setscreen() throws PSErrorStackUnderflow {
        this.getOpStack().pop();
        this.getOpStack().pop();
        this.getOpStack().pop();
    }

    public void op_setstrokeadjust() throws PSErrorTypeCheck, PSErrorStackUnderflow {
        boolean bl = this.getOpStack().pop().toBool();
        this.gstate.current().setStrokeAdjust(bl);
    }

    public void op_shfill() throws PSError, IOException, ProgramError {
        PSObjectDict pSObjectDict = this.getOpStack().pop().toDict();
        this.gstate.current().getDevice().shfill(pSObjectDict, this.gstate.current());
    }

    public void op_show() throws PSError, IOException, ProgramError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        double[] dArray = this.textHandler.showText(this.gstate.current().getDevice(), pSObjectString);
        this.gstate.current().rmoveto(dArray[0], dArray[1]);
    }

    public void op_showpage() {
    }

    public void op_sin() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        double d = this.getOpStack().pop().toReal();
        this.getOpStack().push(new PSObjectReal(Math.sin(d * Math.PI / 180.0)));
    }

    public void op_sqrt() throws PSErrorStackUnderflow, PSErrorTypeCheck, PSErrorRangeCheck {
        double d = this.getOpStack().pop().toNonNegReal();
        d = Math.sqrt(d);
        this.getOpStack().push(new PSObjectReal(d));
    }

    public void op_status() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        if (!(pSObject instanceof PSObjectFile)) {
            throw new PSErrorUnimplemented("'status' operator of non-file object.");
        }
        boolean bl = ((PSObjectFile)pSObject).status();
        this.getOpStack().push(new PSObjectBool(bl));
    }

    public void op_stop() throws PSErrorInvalidStop {
        throw new PSErrorInvalidStop();
    }

    public void op_stopped() throws PSErrorStackUnderflow, PSErrorUnimplemented, ProgramError {
        PSObject pSObject = this.getOpStack().pop();
        try {
            this.runObject(pSObject);
        }
        catch (PSErrorUnimplemented pSErrorUnimplemented) {
            throw pSErrorUnimplemented;
        }
        catch (PSError pSError) {
            this.getOpStack().push(new PSObjectBool(true));
            return;
        }
        this.getOpStack().push(new PSObjectBool(false));
    }

    public void op_string() throws PSErrorStackUnderflow, PSErrorTypeCheck, PSErrorRangeCheck {
        int n = this.getOpStack().pop().toNonNegInt();
        this.getOpStack().push(new PSObjectString(n));
    }

    public void op_stringwidth() throws PSError, IOException, ProgramError {
        PSObjectString pSObjectString = this.getOpStack().pop().toPSString();
        pSObjectString.checkAccess(false, true, false);
        double[] dArray = this.textHandler.showText(this.gstate.current().getDevice(), pSObjectString, true);
        this.getOpStack().push(new PSObjectReal(dArray[0]));
        this.getOpStack().push(new PSObjectReal(dArray[1]));
    }

    public void op_stroke() throws PSError, IOException, ProgramError {
        this.gstate.current().getDevice().stroke(this.gstate.current());
        this.op_newpath();
    }

    public void op_sqBrackLeft() {
        this.getOpStack().push(new PSObjectMark());
    }

    public void op_sqBrackRight() throws PSErrorStackUnderflow, PSErrorTypeCheck, PSErrorUnmatchedMark {
        this.op_counttomark();
        int n = this.getOpStack().pop().toInt();
        PSObject[] pSObjectArray = new PSObject[n];
        for (int i = n - 1; i >= 0; --i) {
            pSObjectArray[i] = this.getOpStack().pop();
        }
        this.getOpStack().pop();
        this.getOpStack().push(new PSObjectArray(pSObjectArray));
    }

    public void op_store() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        PSObjectDict pSObjectDict = this.getDictStack().where(pSObject2);
        if (pSObjectDict != null) {
            this.getDictStack().where(pSObject2).checkAccess(false, false, true);
        }
        this.getDictStack().store(pSObject2, pSObject);
    }

    public void op_sub() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getOpStack().push(pSObject2.sub(pSObject));
    }

    public void op_token() throws PSError, ProgramError {
        PSObject pSObject = this.getOpStack().pop();
        pSObject.checkAccess(false, true, false);
        if (!(pSObject instanceof PSObjectString) && !(pSObject instanceof PSObjectFile)) {
            throw new PSErrorTypeCheck();
        }
        for (PSObject pSObject2 : pSObject.token()) {
            this.getOpStack().push(pSObject2);
        }
    }

    public void op_transform() throws PSError {
        double d;
        PSObject pSObject = this.getOpStack().pop();
        PSObjectMatrix pSObjectMatrix = null;
        try {
            pSObjectMatrix = pSObject.toMatrix();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
        if (pSObjectMatrix == null) {
            pSObjectMatrix = this.gstate.current().getCtm();
            d = pSObject.toReal();
        } else {
            d = this.getOpStack().pop().toReal();
        }
        double d2 = this.getOpStack().pop().toReal();
        double[] dArray = pSObjectMatrix.transform(d2, d);
        this.getOpStack().push(new PSObjectReal(dArray[0]));
        this.getOpStack().push(new PSObjectReal(dArray[1]));
    }

    public void op_translate() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        if (pSObject instanceof PSObjectArray) {
            PSObjectMatrix pSObjectMatrix = pSObject.toMatrix();
            double d = this.getOpStack().pop().toReal();
            double d2 = this.getOpStack().pop().toReal();
            pSObjectMatrix.translate(d2, d);
            this.getOpStack().push(pSObjectMatrix);
        } else {
            double d = pSObject.toReal();
            double d3 = this.getOpStack().pop().toReal();
            this.gstate.current().getCtm().translate(d3, d);
            this.gstate.current().updatePosition();
        }
    }

    public void op_true() {
        this.getOpStack().push(new PSObjectBool(true));
    }

    public void op_truncate() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(pSObject.truncate());
    }

    public void op_type() throws PSErrorStackUnderflow {
        PSObject pSObject = this.getOpStack().pop();
        this.getOpStack().push(new PSObjectName(pSObject.type(), false));
    }

    public void op_undef() throws PSError {
        PSObject pSObject = this.getOpStack().pop();
        PSObjectDict pSObjectDict = this.getOpStack().pop().toDict();
        pSObjectDict.checkAccess(false, false, true);
        pSObjectDict.undef(pSObject);
    }

    public void op_usertime() {
        long l = System.currentTimeMillis();
        int n = (int)(l - this.initializationTime);
        this.getOpStack().push(new PSObjectInt(n));
    }

    public void op_wcheck() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        boolean bl = pSObject.wcheck();
        this.getOpStack().push(new PSObjectBool(bl));
    }

    public void op_where() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        PSObjectDict pSObjectDict = this.getDictStack().where(pSObject);
        if (pSObjectDict == null) {
            this.getOpStack().push(new PSObjectBool(false));
        } else {
            this.getOpStack().push(pSObjectDict);
            this.getOpStack().push(new PSObjectBool(true));
        }
    }

    public void op_xcheck() throws PSErrorStackUnderflow {
        PSObject pSObject = this.getOpStack().pop();
        PSObjectBool pSObjectBool = new PSObjectBool(pSObject.xcheck());
        this.getOpStack().push(pSObjectBool);
    }

    public void op_xor() throws PSErrorStackUnderflow, PSErrorTypeCheck {
        PSObject pSObject = this.getOpStack().pop();
        PSObject pSObject2 = this.getOpStack().pop();
        this.getOpStack().push(pSObject2.xor(pSObject));
    }

    public void op_xshow() throws PSError, IOException, ProgramError {
        this.log.info("xshow operator encoutered. xshow is not implemented, instead the normal show is used.");
        this.getOpStack().pop();
        this.op_show();
    }

    public void op_xyshow() throws PSError, IOException, ProgramError {
        this.log.info("xyshow operator encoutered. xyshow is not implemented, instead the normal show is used.");
        this.getOpStack().pop();
        this.op_show();
    }

    public void op_yshow() throws PSError, IOException, ProgramError {
        this.log.info("yshow operator encoutered. yshow is not implemented, instead the normal show is used.");
        this.getOpStack().pop();
        this.op_show();
    }

    private void rectPath() throws PSError {
        this.op_newpath();
        PSObject pSObject = this.getOpStack().pop();
        if (pSObject instanceof PSObjectInt || pSObject instanceof PSObjectReal) {
            double d = pSObject.toReal();
            double d2 = this.getOpStack().pop().toReal();
            double d3 = this.getOpStack().pop().toReal();
            double d4 = this.getOpStack().pop().toReal();
            this.rectPathSingle(d4, d3, d2, d);
        } else if (pSObject instanceof PSObjectArray) {
            PSObjectArray pSObjectArray = pSObject.toArray();
            if (pSObjectArray.length() % 4 != 0) {
                throw new PSErrorRangeCheck();
            }
            int n = pSObjectArray.length() / 4;
            for (int i = 0; i < n; ++i) {
                double d = pSObjectArray.get(4 * i).toReal();
                double d5 = pSObjectArray.get(4 * i + 1).toReal();
                double d6 = pSObjectArray.get(4 * i + 2).toReal();
                double d7 = pSObjectArray.get(4 * i + 3).toReal();
                this.rectPathSingle(d, d5, d6, d7);
            }
        } else if (pSObject instanceof PSObjectString) {
            PSObjectString pSObjectString = pSObject.toPSString();
            int n = pSObjectString.numstringLength() / 4;
            for (int i = 0; i < n; ++i) {
                double d = pSObjectString.numstringGet(4 * i);
                double d8 = pSObjectString.numstringGet(4 * i + 1);
                double d9 = pSObjectString.numstringGet(4 * i + 2);
                double d10 = pSObjectString.numstringGet(4 * i + 3);
                this.rectPathSingle(d, d8, d9, d10);
            }
        } else {
            throw new PSErrorTypeCheck();
        }
    }

    private void rectPathSingle(double d, double d2, double d3, double d4) throws PSError {
        this.gstate.current().moveto(d, d2);
        this.gstate.current().rlineto(d3, 0.0);
        this.gstate.current().rlineto(0.0, d4);
        this.gstate.current().rlineto(-d3, 0.0);
        this.op_closepath();
    }

    public GstateStack getGstate() {
        return this.gstate;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }
}

