/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.resources.colors.DeviceRGB;
import net.sf.eps2pgf.ps.resources.colors.PSColor;

public class DeviceCMYK
extends PSColor {
    public static final PSObjectName FAMILYNAME = new PSObjectName("/DeviceCMYK");
    private static final double[] DEFAULT_LEVELS = new double[]{0.0, 0.0, 0.0, 1.0};

    public DeviceCMYK() {
        try {
            this.setColor(DEFAULT_LEVELS);
        }
        catch (PSError pSError) {
        }
        catch (ProgramError programError) {
            // empty catch block
        }
    }

    public DeviceCMYK clone() throws CloneNotSupportedException {
        DeviceCMYK deviceCMYK = (DeviceCMYK)super.clone();
        return deviceCMYK;
    }

    public double[] getCMYK() {
        double[] dArray = new double[]{this.getLevel(0), this.getLevel(1), this.getLevel(2), this.getLevel(3)};
        return dArray;
    }

    public PSObjectArray getColorSpace() {
        PSObjectArray pSObjectArray = new PSObjectArray();
        pSObjectArray.addToEnd(new PSObjectName("DeviceCMYK", true));
        return pSObjectArray;
    }

    public double getGray() {
        return 1.0 - Math.min(1.0, 0.3 * this.getLevel(0) + 0.59 * this.getLevel(1) + 0.11 * this.getLevel(2) + this.getLevel(3));
    }

    public double[] getHSB() {
        double[] dArray = this.getRGB();
        return DeviceRGB.convertRGBtoHSB(dArray[0], dArray[1], dArray[2]);
    }

    public int getNrComponents() {
        return 4;
    }

    public int getNrInputValues() {
        return this.getNrComponents();
    }

    public String getPreferredColorSpace() {
        return "CMYK";
    }

    public double[] getRGB() {
        double d = 1.0 - Math.min(1.0, this.getLevel(0) + this.getLevel(3));
        double d2 = 1.0 - Math.min(1.0, this.getLevel(1) + this.getLevel(3));
        double d3 = 1.0 - Math.min(1.0, this.getLevel(2) + this.getLevel(3));
        double[] dArray = new double[]{d, d2, d3};
        return dArray;
    }

    public PSObjectName getFamilyName() {
        return FAMILYNAME;
    }
}

