% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguStatus.R
\name{pgu.status}
\alias{pgu.status}
\title{pgu.status}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
A class that keeps track of the pguIMP analysis process.
}
\details{
pguIMP uses a defined linear analysis path
The current status therefore provides information about
which analyses have already been performed and which
still have to be performed.
This way pguIMG knows any time during analysis,
if all necessary information for the next desired analysis
step are available.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{processAlphabet}}{Reurns the process alphabet of
the pguIMP analysis routine.
(character)}

\item{\code{processStatus}}{Returns the process status of the pguIMP routine.
(logical)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.status$new()}}
\item \href{#method-finalize}{\code{pgu.status$finalize()}}
\item \href{#method-print}{\code{pgu.status$print()}}
\item \href{#method-reset}{\code{pgu.status$reset()}}
\item \href{#method-update}{\code{pgu.status$update()}}
\item \href{#method-query}{\code{pgu.status$query()}}
\item \href{#method-clone}{\code{pgu.status$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.status`` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.status$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{pgu.status} object.
(pguIMP::pgu.status)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates if instance of \code{pgu.status} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.status$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.status} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.status$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
resets the intance variables \code{processAlphabet} and \code{processStatus} to their initial values (FALSE).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.status$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update"></a>}}
\if{latex}{\out{\hypertarget{method-update}{}}}
\subsection{Method \code{update()}}{
updates the process status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.status$update(processName = "character", value = "logical")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{processName}}{The name of the \code{pguIMP} process that has been performed.
(character)}

\item{\code{value}}{Indicates if the process ended with success.
(logical)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-query"></a>}}
\if{latex}{\out{\hypertarget{method-query}{}}}
\subsection{Method \code{query()}}{
Queries if a process has already been performed successfully.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.status$query(processName = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{processName}}{Name of the process to be checked.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Status of the queried process
(logical)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.status$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
