% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distSeq.R
\name{writeDist}
\alias{writeDist}
\alias{write.nexus.dist}
\alias{readDist}
\alias{unique.dist}
\title{Writing and reading distances in phylip and nexus format}
\usage{
writeDist(x, file = "", format = "phylip", ...)

write.nexus.dist(x, file = "", append = FALSE, upper = FALSE,
  diag = TRUE, digits = getOption("digits"), taxa = !append)

readDist(file)

\method{unique}{dist}(x, incomparables, ...)
}
\arguments{
\item{x}{A \code{dist} object.}

\item{file}{A file name.}

\item{format}{file format, default is "phylip", only other option so far is
"nexus".}

\item{\dots}{Further arguments passed to or from other methods.}

\item{append}{logical. If TRUE the nexus blocks will be added to a file.}

\item{upper}{logical value indicating whether the upper triangle of the
distance matrix should be printed.}

\item{diag}{logical value indicating whether the diagonal of the distance
matrix should be printed.}

\item{digits}{passed to format inside of \code{write.nexus.dist}.}

\item{taxa}{logical. If TRUE a taxa block is added.}

\item{incomparables}{Not used so far.}
}
\value{
an object of class \code{dist}
}
\description{
\code{readDist}, \code{writeDist} and \code{write.nexus.dist} are useful to
exchange distance matrices with other phylogenetic programs.
}
\examples{

data(yeast)
dm <- dist.ml(yeast)
writeDist(dm)
write.nexus.dist(dm)

}
\references{
Maddison, D. R., Swofford, D. L. and Maddison, W. P. (1997)
NEXUS: an extensible file format for systematic information.
\emph{Systematic Biology}, \bold{46}, 590--621.
}
\seealso{
To compute distance matrices see \code{\link{dist.ml}}
\code{\link[ape]{dist.dna}} and \code{\link{dist.p}} for pairwise
polymorphism p-distances
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
