% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_covariate_effect}
\alias{add_covariate_effect}
\title{add_covariate_effect}
\usage{
add_covariate_effect(model, parameter, covariate, effect, operation = "*")
}
\arguments{
\item{model}{(Model) Pharmpy model to add covariate effect to.}

\item{parameter}{(str) Name of parameter to add covariate effect to.}

\item{covariate}{(str) Name of covariate.}

\item{effect}{(str) Type of covariate effect. May be abbreviated covariate effect (see above) or custom.}

\item{operation}{(str, optional) Whether the covariate effect should be added or multiplied (default).}
}
\value{
(Model) Reference to the same model
}
\description{
Adds covariate effect to :class:\code{pharmpy.model}.

The following effects have templates:
\itemize{
\item Linear function for continuous covariates (\emph{lin})
\item Function:
}

math::

{coveff} = 1 + {theta} * ({cov} - {median})
\itemize{
\item Init:  0.001
\item Upper:
\item If median of covariate equals minimum: :math:\verb{100,000}
\item Otherwise: :math:\verb{frac\{1\}\{\{median\} - \{min\}\}}
\item Lower:
\item If median of covariate equals maximum: :math:\verb{-100,000}
\item Otherwise: :math:\verb{frac\{1\}\{\{median\} - \{max\}\}}
\item Linear function for categorical covariates (\emph{cat})
\item Function:
\item If covariate is most common category:
}

math::

{coveff} = 1
\itemize{
\item For each additional category:
}

math::

{coveff} = 1 + {theta}
\itemize{
\item Init: :math:\code{0.001}
\item Upper: :math:\verb{100,000}
\item Lower: :math:\verb{-100,000}
\item Piecewise linear function/"hockey-stick", continuous covariates only (\emph{piece_lin})
\item Function:
\item If cov <= median:
}

math::

{coveff} = 1 + {theta1} * ({cov} - {median})
\itemize{
\item If cov > median:
}

math::

{coveff} = 1 + {theta2} * ({cov} - {median})
\itemize{
\item Init: :math:\code{0.001}
\item Upper:
\item For first state: :math:\verb{frac\{1\}\{\{median\} - \{min\}\}}
\item Otherwise: :math:\verb{100,000}
\item Lower:
\item For first state: :math:\verb{-100,000}
\item Otherwise: :math:\verb{frac\{1\}\{\{median\} - \{max\}\}}
\item Exponential function, continuous covariates only (\emph{exp})
\item Function:
}

math::

{coveff} = exp({theta} * ({cov} - {median}))
\itemize{
\item Init:
\item If lower > 0.001 or upper < 0.001: :math:\verb{frac\{\{upper\} - \{lower\}\}\{2\}}
\item If estimated init is 0: :math:\verb{frac\{\{upper\}\}\{2\}}
\item Otherwise: :math:\code{0.001}
\item Upper:
\item If min - median = 0 or max - median = 0: :math:\code{100}
\item Otherwise:
}

math::

min(frac{log(0.01)}{{min} - {median}},
frac{log(100)}{{max} - {median}})
\itemize{
\item Lower:
\item If min - median = 0 or max - median = 0: :math:\code{0.01}
\item Otherwise:
}

math::

max(frac{log(0.01)}{{max} - {median}},
frac{log(100)}{{min} - {median}})
\itemize{
\item Power function, continuous covariates only (\emph{pow})
\item Function:
}

math::

{coveff} = (frac{{cov}}{{median}})^{theta}
\itemize{
\item Init: :math:\code{0.001}
\item Upper: :math:\verb{100,000}
\item Lower: :math:\code{-100}
}
}
\examples{
\dontrun{
model <- load_example_model("pheno")
add_covariate_effect(model, "CL", "APGR", "exp")
model$statements$full_expression_from_odes("CL")
}

}
