% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_individual_parameters}
\alias{get_individual_parameters}
\title{get_individual_parameters}
\usage{
get_individual_parameters(model, level = "all")
}
\arguments{
\item{model}{(Model) Pharmpy model to retrieve the individuals parameters from}

\item{level}{(str) The variability level to look for: 'iiv', 'iov', or 'all' (default)}
}
\value{
(vector) A vector of the parameters' names as strings
}
\description{
Retrieves all parameters with IIV or IOV in :class:\code{pharmpy.model}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
sorted(get_individual_parameters(model))
sorted(get_individual_parameters(model, 'iiv'))
get_individual_parameters(model, 'iov')
}
}
\seealso{
get_pk_parameters

has_random_effect
}
