% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{calculate_pk_parameters_statistics}
\alias{calculate_pk_parameters_statistics}
\title{calculate_pk_parameters_statistics}
\usage{
calculate_pk_parameters_statistics(
  model,
  parameter_estimates,
  covariance_matrix = NULL,
  rng = NULL
)
}
\arguments{
\item{model}{(Model) A previously estimated model}

\item{parameter_estimates}{(array) Parameter estimates}

\item{covariance_matrix}{(data.frame (optional)) Parameter uncertainty covariance matrix}

\item{rng}{(numeric (optional)) Random number generator or seed}
}
\value{
(data.frame) A DataFrame of statistics indexed on parameter and covariate value.
}
\description{
Calculate statistics for common pharmacokinetic parameters

Calculate the mean (expected value of the distribution), variance
(variance of the distribution) and standard error for some individual
pre-defined pharmacokinetic parameters.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
rng <- create_rng(23)
pe <- results$parameter_estimates
cov <- results$covariance_matrix
calculate_pk_parameters_statistics(model, pe, cov, rng=rng)
}
}
\seealso{
calculate_individual_parameter_statistics : Calculation of statistics for arbitrary parameters
}
