% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_initial_conditions}
\alias{get_initial_conditions}
\title{get_initial_conditions}
\usage{
get_initial_conditions(model, dosing = FALSE)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{dosing}{(logical) Set to TRUE to add dosing as initial conditions}
}
\value{
(list) Initial conditions
}
\description{
Get initial conditions for the ode system

Default initial conditions at t=0 for amounts is 0
}
\examples{
\dontrun{
model <- load_example_model("pheno")
get_initial_conditions(model)
get_initial_conditions(model, dosing=TRUE)
}

}
