% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indActogramWake.R
\name{indActogramWake}
\alias{indActogramWake}
\title{Generate actogram for "wake" data for individual fly}
\usage{
indActogramWake(
  data,
  sleep.def = c(5),
  bin = 30,
  t.cycle = 24,
  ind = 1,
  key.wake = 1
)
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function trimData(). See ??trimData().}

\item{sleep.def}{Definition of sleep. Traditionally, a single bout of sleep is defined as any duration of inactivity that is equal to or greater than 5-minutes. However, sometimes it may be of interest to examine longer bouts of sleep; sleep.def allows users to change the definition of sleep. This defaults to 5.}

\item{bin}{Intervals in which data are saved (in minutes). This defaults to 30. The value of bin cannot be lower than that of sleep.def.}

\item{t.cycle}{Define the period of the environmental cycle or a single day in hours. This defaults to 24.}

\item{ind}{The channel number (or individual) whose actogram must be plotted.}

\item{key.wake}{Key for reactive input tables in the shiny app.}
}
\value{
A \code{plotly} \code{htmlwidget} with the actogram (wake data) of a user defined fly.
}
\description{
This function allows users to generate individual actograms for "wake" data. Input for this function must be an output from the trimData() function. The output of this function is a plotly object.
In a particular bin, sleep is calculated as the total minutes of inactivity equal to or greater than the defined threshold (sleep.def; typically, 5-minutes). Wake is defined as the total time spent by the fly not sleeping. See also wakeData().
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 10, bin = 1, t.cycle = 24)
ind.actogram.wake <- indActogramWake(data = td, ind = 7)
}
