% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_phenocam.r
\name{process_phenocam}
\alias{process_phenocam}
\title{Function to post-process PhenoCam time series}
\usage{
process_phenocam(
  file,
  outlier_detection = TRUE,
  smooth = TRUE,
  contract = FALSE,
  expand = TRUE,
  truncate,
  phenophase = TRUE,
  snow_flag = FALSE,
  penalty = 0.5,
  out_dir = tempdir(),
  internal = FALSE,
  ...
)
}
\arguments{
\item{file}{1 or 3-day PhenoCam time series file path}

\item{outlier_detection}{TRUE or FALSE, detect outliers}

\item{smooth}{smooth data (logical, default is \code{TRUE})}

\item{contract}{contract 3-day data upon output
(logical, default is \code{TRUE})}

\item{expand}{expand 3-day data upon input 
(logical, default is \code{TRUE})}

\item{truncate}{year (numeric) to which to constrain the output}

\item{phenophase}{logical, calculate transition dates (default = \code{FALSE})}

\item{snow_flag}{integrate snow flags?}

\item{penalty}{how sensitive is the change point algorithm, lower is more
sensitve (< 1, default = 0.5)}

\item{out_dir}{output directory where to store downloaded data 
(default = tempdir())}

\item{internal}{allow for the data element to be returned to the workspace}

\item{...}{additional parameters to be forwarded to the phenophases()
function, used internally in the routine}
}
\value{
Downloaded files in out_dir of requested time series products, as well
as derived phenophase estimates based upon these time series.
}
\description{
Wrapper around other more basic funtions, in order to generate phenocam
data products.
}
\examples{

\dontrun{
# download the first ROI time series for the Harvard PhenoCam site
# at an aggregation frequency of 3-days.
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3")
 
# read phenocam data into phenocamr data structure                  
df <- process_phenocam(file.path(tempdir(),"harvard_DB_1000_3day.csv"))
                  
}
}
