#' Result of the mcmc for Leatherback nest counts from Gratiot et al. (2006) Figure 1
#' @title Result of the mcmc for Leatherback nest counts
#' @author Marc Girondot \email{marc.girondot@@u-psud.fr}
#' @docType data
#' @name result_Gratiot_mcmc
#' @description Result of the mcmc for Leatherback nest counts from Gratiot et al. (2006) Figure 1
#' The phenology has been fitted with MinE, MinB, Max, Flat, LengthB, LengthE, Peak, Theta.
#' @references Gratiot, N., Gratiot, J., de Thoisy, B. & Kelle, L. 2006. 
#'             Estimation of marine turtles nesting season from incomplete 
#'             data ; statistical adjustment of a sinusoidal function. Animal 
#'             Conservation, 9, 95-102.
#' @keywords datasets
#' @usage result_Gratiot_mcmc
#' @examples
#' library(phenology)
#' # Read a file with result
#' data(result_Gratiot_mcmc)
#' @format A mcmcComposite object with mcmc result.
NULL
