% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_format.R
\name{Tagloss_format}
\alias{Tagloss_format}
\title{Format a CMR dataset into a file that Tagloss_L can use.}
\usage{
Tagloss_format(data, model = "21", progressbar = TRUE)
}
\arguments{
\item{data}{CMR file}

\item{model}{Can be "21" or "LR"}

\item{progressbar}{Is a progressbar been shown?}
}
\value{
Return the maximum number of days an individual has been observed in a dataset.
}
\description{
This function formats a CMR dataset to a file that Tagloss_L can use.\cr
The format of data is a data.frame with 4 columns:\cr
ID is the column with the permanent identification code\cr
L is the column with the non-permanent code located at left\cr
R is the column with the non-permanent code located at right\cr
Date is the column with the date of observation\cr
Note that R and L columns can be exchanged if 21 model is used.
}
\details{
Tagloss_format formats a CMR dataset into a file that Tagloss_L can use.
}
\examples{
\dontrun{
library(phenology)
# Example
data_f_21 <- Tagloss_format(outLR, model="21")
}
}
\seealso{
Other Model of Tag-loss: \code{\link{Tagloss_LengthObs}},
  \code{\link{Tagloss_L}}, \code{\link{Tagloss_daymax}},
  \code{\link{Tagloss_fit}}, \code{\link{Tagloss_model}},
  \code{\link{Tagloss_simulate}},
  \code{\link{plot.Tagloss}}
}
\author{
Marc Girondot
}
