% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phraseDoc.R
\name{phraseDoc}
\alias{phraseDoc}
\title{phraseDoc Creation}
\usage{
phraseDoc(
  txts,
  mn = 2,
  mx = 8,
  ssw = stopStartWords(),
  sew = stopEndWords(),
  sp = stopPhrases(),
  min.freq = 2,
  pp = function(phrase, freq) {     ifelse(freq < min.freq, return(FALSE),
    return(TRUE)) },
  max.phrases = 1500,
  shiny = FALSE,
  silent = FALSE
)
}
\arguments{
\item{txts}{A character vector with each element the contents of a document,
or a VCorpus object.}

\item{mn}{Minimum number of words in a phrase.}

\item{mx}{Maximum number of words in a phrase.}

\item{ssw}{A set of words no phrase should start with.}

\item{sew}{A set of words no phrase should end with.}

\item{sp}{A set of phrases to be excluded.}

\item{min.freq}{The minimum frequency of phrases to be included.}

\item{pp}{Function that determines if a phrase is a principal phrase. By
default, FALSE is returned if the phrase occurs less often than the number
in \code{min.freq}.}

\item{max.phrases}{Maximum number of phrases to be included.}

\item{shiny}{TRUE if called from a shiny program.}

\item{silent}{TRUE if you do not want progress messages.}
}
\value{
object of class phraseDoc.
}
\description{
Create an object of class phraseDoc. This will hold all principal phrases of
a collection of texts that occur a minimum number of times, plus the texts
they occur in and their position within those texts.
}
\examples{
tst=c("This is a test text",
      "This is a test text 2",
      "This is another test text",
      "This is another test text 2",
      "This girl will test text that man",
      "This boy will test text that man")
pd=phraseDoc(tst)
}
