% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFSource.R
\name{readDF}
\alias{readDF}
\title{Create a PlainTextDocument from a row in a data frame}
\usage{
readDF(elem, language, id = "1")
}
\arguments{
\item{elem}{A list containing the field content containing one
row with data from a data frame containing at least the columns id and text,
but possibly more.}

\item{language}{abbreviation of the language used; "en" for English}

\item{id}{Not used, but needed for VCorpus}
}
\value{
A PlainTextDocument with content equal to the contents of the
text field, and meta data containing the information in the remaining
fields, including the id field
}
\description{
Read a row of the content of a DFSource object into a PlainTextDocument.
}
\examples{
(df=data.frame(id=1:3,text=c("First text","Second text","Third text"),
               title=c("N1","N2","N3")))
readDF(list(content=df[1,]),"en")
}
