% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch_to_df.R
\name{pitch_to_df}
\alias{pitch_to_df}
\title{Praat Pitch tier to dataframe}
\usage{
pitch_to_df(file_name, candidates = "")
}
\arguments{
\item{file_name}{string with a filename or path to the Pitch tier}

\item{candidates}{Praat Pitch tier contains multiple candidates for each
time slice, use the value \code{"all"} if you want to get them all}
}
\value{
a dataframe with columns:  \code{time_start}, \code{time_end},
\code{frequency} and, if \code{candidates} = \code{"all"},
\code{candidate_id} and \code{strength}
}
\description{
Convert a Praat Pitch tier to a dataframe.
}
\examples{
pitch_to_df(system.file("extdata", "test.Pitch", package = "phonfieldwork"))
}
\author{
George Moroz <agricolamz@gmail.com>
}
