% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct-wide2long.r
\name{spct_wide2long}
\alias{spct_wide2long}
\title{Convert spectrum from wide to long form}
\usage{
spct_wide2long(
  spct,
  fixed.cols = "w.length",
  idfactor = "spct.idx",
  rm.spct.class = FALSE,
  ...
)
}
\arguments{
\item{spct}{An object with spectral data.}

\item{fixed.cols}{character Names of variables that should be copied
unchanged for each spectrum.}

\item{idfactor}{character The name of the factor to be added to the long-form
object and used to store the original name of the columns as an index
to the different spectra.}

\item{rm.spct.class}{logical If true the returned object is a data frame.}

\item{...}{Currently ignored.}
}
\value{
An object of the same class as \code{spct} or a \code{data.frame}
  with derived classes removed.
}
\description{
Convert spectrum from wide to long form
}
\details{
Only objects of classes raw_spct, cps_spct, and object_spct normally contain
multiple columns of spectral data. These are supported as well as
generic_spct. Is the wide spectra contain multiple spectra in long form,
the original \code{idfactor} is preserved.

Spectra that are already in long form, if passed as argument, are returned
unchanged.

Because the classes defined for spectra have a well defined format, and
known column names we can define a rather simple function for this
operation.
}
\examples{

spct_wide2long(white_led.raw_spct)
spct_wide2long(white_led.cps_spct)
spct_wide2long(Ler_leaf.spct)

}
