% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.normalize.r
\name{getNormalized}
\alias{getNormalized}
\alias{getNormalised}
\alias{getNormalization}
\alias{getNormalisation}
\title{Query the "normalized" and "normalization" attributes}
\usage{
getNormalized(x, .force.numeric = FALSE)

getNormalised(x, .force.numeric = FALSE)

getNormalization(x)

getNormalisation(x)
}
\arguments{
\item{x}{a generic_spct object.}

\item{.force.numeric}{logical If \code{TRUE} always silently return a
numeric value, with \code{FALSE} encoded as zero, and character values
as \code{NA}.}
}
\value{
\code{getNormalized()} returns numeric or logical (possibly character
  for objects created with earlier versions). If \code{x} is not a
  \code{generic_spct} object, \code{NA} or a list with fields set to NAs is
  returned. Objects created with versions of package 'photobiology' earlier
  than 0.10.8 are lacking the normalization metadata.

\code{getNormalization()} returns a list with five fields: norm.type,
  norm.wl, norm.factors, norm.cols, norm.range. See
  \code{\link{setNormalized}()} for the values stored in the fields.
}
\description{
Functions to read the "normalized" and "normalization" attributes of an
existing generic_spct object.
}
\details{
Spectral data that has been normalized needs to be used diffferently
  in computations than data expresed in original units. These two functions
  make it possible to query if data stored in an object of class
  \code{generic_spct} or of a derived class contains data expressed in
  physical units or normalized. In the later case, it is possible to also
  query how the normalization was done.
}
\note{
\code{getNormalised()} is a synonym for this \code{getNormalized()}
  method.
}
\examples{

getNormalized(sun.spct)
getNormalization(sun.spct)

sun_norm.spct <- normalize(sun.spct)

getNormalized(sun_norm.spct)
getNormalization(sun_norm.spct)

getNormalization(e2q(sun_norm.spct))

gel_norm.spct <- normalize(yellow_gel.spct)

getNormalized(gel_norm.spct)
getNormalization(gel_norm.spct)

getNormalization(T2Afr(gel_norm.spct))
getNormalization(any2A(gel_norm.spct))

}
\seealso{
Other rescaling functions: 
\code{\link{fscale}()},
\code{\link{fshift}()},
\code{\link{getScaled}()},
\code{\link{is_normalized}()},
\code{\link{is_scaled}()},
\code{\link{normalize}()},
\code{\link{setNormalized}()},
\code{\link{setScaled}()}
}
\concept{rescaling functions}
