% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.sample.R
\name{pull_sample}
\alias{pull_sample}
\alias{pull_sample.default}
\alias{pull_sample.list}
\alias{pull_sample.generic_spct}
\alias{pull_sample.generic_mspct}
\title{Random sample of spectra}
\usage{
pull_sample(x, size, ...)

\method{pull_sample}{default}(x, size, ...)

\method{pull_sample}{list}(
  x,
  size = 1,
  replace = FALSE,
  keep.order = TRUE,
  simplify = FALSE,
  ...
)

\method{pull_sample}{generic_spct}(
  x,
  size = 1,
  replace = FALSE,
  recursive = FALSE,
  keep.order = TRUE,
  ...
)

\method{pull_sample}{generic_mspct}(
  x,
  size = 1,
  replace = FALSE,
  recursive = FALSE,
  keep.order = TRUE,
  simplify = FALSE,
  ...
)
}
\arguments{
\item{x}{An R object possibly containing multiple spectra or other
components.}

\item{size}{integer The number of spectra to extract, if available.}

\item{...}{currently ignored.}

\item{replace}{logical Sample with or without replacement.}

\item{keep.order}{logical Return the spectra ordered as in \code{x} or in
random order.}

\item{simplify}{logical If \code{size = 1}, and \code{x} is a collection
return the spectrum object instead of a collection with it as only member.}

\item{recursive}{logical If \code{x} is a collection, expand or not member
spectra containing multiple spectra in long form into individual members
before sampling.}
}
\value{
If \code{x} is an spectrum object, such as a
  \code{"filter_spct"} object, the returned object is of the same class but
  in most cases containing fewer spectra in long form than \code{x}.
   If \code{x} is a collection of spectrum objecta, such as a
  \code{"filter_mspct"} object, the returned object is of the same class but
  in most cases containing fewer member spectra than \code{x}.
}
\description{
A method to extract a random sample of members from a list, a collection of
spectra or a spectrum object containing multiple spectra in long form.
}
\section{Methods (by class)}{
\itemize{
\item \code{pull_sample(default)}: Default for generic function

\item \code{pull_sample(list)}: Specialization for generic_spct

\item \code{pull_sample(generic_spct)}: Specialization for generic_spct

\item \code{pull_sample(generic_mspct)}: Specialization for generic_mspct

}}
\examples{
a.list <- as.list(letters)
names(a.list) <- LETTERS
set.seed(12345678)
pull_sample(a.list, size = 8)
pull_sample(a.list, size = 8, keep.order = FALSE)
pull_sample(a.list, size = 8, replace = TRUE)
pull_sample(a.list, size = 8, replace = TRUE, keep.order = FALSE)
pull_sample(a.list, size = 1)
pull_sample(a.list, size = 1, simplify = TRUE)

}
\seealso{
See \code{\link[base]{sample}} for the method used for
  the sampling.
}
