% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.data.r
\docType{data}
\name{ccd.spct}
\alias{ccd.spct}
\title{Spectral response of a back-thinned CCD image sensor.}
\format{
A \code{response_spct} object with 186 rows and 2 variables
}
\usage{
ccd.spct
}
\description{
A dataset containing wavelengths at a 1 nm interval and
  spectral response as quantum efficiency for CCD sensor type
  S11071/S10420 from Hamamatsu (measured without a quartz window). These
  vectors are frequently used as sensors in high-UV-sensitivity vector
  spectrometers. Data digitized from manufacturer's data sheet.
  The original data is expressed as percent quantum efficiency with a value
  of 77\% at the peak. The data have been re-expressed as fractions of one.
}
\details{
\itemize{ \item w.length (nm). \item s.q.response
(fractional quantum efficiency)  }
}
\examples{
ccd.spct

}
\references{
Hamamatsu (2014) Datasheet: CCD Image Sensors S11071/S10420-01 Series.
Hamamatsu Photonics KK, Hamamatsu, City.
http://www.hamamatsu.com/jp/en/S11071-1004.html.
Visited 2017-12-15.
}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D50.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_filters.spct}},
\code{\link{two_sensors.mspct}},
\code{\link{water.spct}},
\code{\link{white_led.source_spct}}
}
\concept{Spectral data examples}
\keyword{datasets}
