% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.conversion.R
\name{cps2irrad}
\alias{cps2Rfr}
\alias{cps2Tfr}
\alias{cps2irrad}
\title{Conversion from counts per second to physical quantities}
\usage{
cps2irrad(x.sample, pre.fun = NULL, ...)

cps2Rfr(x.sample, x.white, x.black = NULL, dyn.range = NULL)

cps2Tfr(x.sample, x.clear, x.opaque = NULL, dyn.range = NULL)
}
\arguments{
\item{x.sample, x.clear, x.opaque, x.white, x.black}{cps_spct objects.}

\item{pre.fun}{function A function applied to x.sample before converison.}

\item{...}{Additional arguments passed to \code{pre.fun}.}

\item{dyn.range}{numeric The effective dynamic range of the instrument,
if \code{NULL} it is automatically set based on integartion time
bracketing.}
}
\value{
A source_spct, filter_spct or reflector_spct object containing the
  spectral values expressed in physical units.
}
\description{
Conversion of spectral data expressed as cps into irradiance, transmittance
or reflectance.
}
\note{
In contrast to other classes defined in package 'photobiology', class
  "cps_spct" can have more than one column of cps counts in cases where the
  intention is to merge these values as part of the processing at the time
  the calibration is applied. However, being these functions the final step
  in the conversion to physical units, they accept as input only objects
  with a single "cps" column, as merging is expected to have been already
  done.
}

