% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photon.ratio.r
\name{photon_ratio}
\alias{photon_ratio}
\title{Photo:photon ratio}
\usage{
photon_ratio(w.length, s.irrad, w.band.num = NULL, w.band.denom = NULL,
  unit.in = "energy", check.spectrum = TRUE, use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL))
}
\arguments{
\item{w.length}{numeric array of wavelength (nm)}

\item{s.irrad}{numeric array of spectral (energy) irradiances (W m-2 nm-1)}

\item{w.band.num}{waveband}

\item{w.band.denom}{waveband}

\item{unit.in}{character Allowed values "energy", and "photon",
or its alias "quantum"}

\item{check.spectrum}{logical Flag telling whether to sanity check input data,
default is TRUE}

\item{use.cached.mult}{logical Flag telling whether multiplier values should be
cached between calls}

\item{use.hinges}{logical Flag telling whether to use hinges to reduce
interpolation errors}
}
\value{
a single numeric value giving the unitless ratio
}
\description{
This function gives the photon ratio between two given wavebands of a
radiation spectrum.
}
\examples{
# photon:photon ratio
with(sun.data,
     photon_ratio(w.length, s.e.irrad, new_waveband(400,500), new_waveband(400,700)))
# photon:photon ratio waveband : whole spectrum
with(sun.data, photon_ratio(w.length, s.e.irrad, new_waveband(400,500)))
# photon:photon ratio of whole spectrum should be equal to 1.0
with(sun.data, photon_ratio(w.length, s.e.irrad))

}
\seealso{
Other photon and energy ratio functions: \code{\link{e_ratio}},
  \code{\link{energy_ratio}}, \code{\link{eq_ratio}},
  \code{\link{photons_energy_ratio}},
  \code{\link{q_ratio}}, \code{\link{qe_ratio}}
}
