% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{spread}
\alias{spread}
\alias{spread.default}
\alias{spread.numeric}
\alias{spread.waveband}
\alias{spread.generic_spct}
\alias{spread.generic_mspct}
\title{Length of object in wavelength units}
\usage{
spread(x, ...)

\method{spread}{default}(x, ...)

\method{spread}{numeric}(x, ...)

\method{spread}{waveband}(x, ...)

\method{spread}{generic_spct}(x, ...)

\method{spread}{generic_mspct}(x, ..., idx = !is.null(names(x)))
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
A numeric value equal to max(x) - min(x). In the case of spectral
  objects wavelength difference in nm. For any other R object, according to
  available definitions of \code{\link{min}} and \code{\link{max}}.
}
\description{
A function that returns the spread (max(x) - min(x)) for R objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for generic function

\item \code{numeric}: Method for "numeric"

\item \code{waveband}: Method for "waveband"

\item \code{generic_spct}: Method for "generic_spct"

\item \code{generic_mspct}: Method for "generic_mspct" objects.
}}

\examples{
spread(sun.spct)

}
