% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalized.diff.idx.r
\name{normalized_diff_ind}
\alias{normalized_diff_ind}
\title{Calculate a normalized index.}
\usage{
normalized_diff_ind(spct, plus.w.band, minus.w.band, f, ...)
}
\arguments{
\item{spct}{an R object}

\item{plus.w.band}{waveband objects The waveband determine the
region of the spectrum used in the calculations}

\item{minus.w.band}{waveband objects The waveband determine the
region of the spectrum used in the calculations}

\item{f}{function used for integration taking spct as first argument and a
list of wavebands as second argument.}

\item{...}{additional arguments passed to f}
}
\value{
A numeric value for the index
}
\description{
This function returns a normalized difference index value for an arbitrary
pair of wavebands.
}
\note{
\code{f} is most frequently \code{\link{reflectance}}, but also
  \code{\link{transmittance}}, or even \code{\link{absorbance}},
  \code{\link{response}}, \code{\link{irradiance}} or a user-defined function
  can be used if there is a good reason for it. In every case \code{spct}
  should be of the class expected by \code{f}. When using two wavebands of
  different widths do consider passing to \code{f} a suitable \code{quantity}
  argument. Wavebands can describe weighting functions if desired.
}
