% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{as.matrix-mspct}
\alias{as.matrix-mspct}
\alias{as.matrix.generic_mspct}
\alias{mspct2mat}
\title{Coerce a collection of spectra into a matrix}
\usage{
\method{as.matrix}{generic_mspct}(x, spct.data.var, byrow = attr(x,
  "mspct.byrow"), ...)

mspct2mat(x, spct.data.var, byrow = attr(x, "mspct.byrow"), ...)
}
\arguments{
\item{x}{generic_mspct object.}

\item{spct.data.var}{character The name of the variable containing the spectral data.}

\item{byrow}{logical. If FALSE (the default) the matrix is filled with the
spectra stored by columns, otherwise the matrix is filled by rows.}

\item{...}{currently ignored.}
}
\description{
Convert an object of class \code{generic_mspct} or a derived class into an R
matrix with wavelengths saved as an attribute and spectral data in rows
or columns.
}
\note{
Only collections of spectra containing spectra with exactly the same
\code{w.length} values can by converted. If needed, the spectra can be
re-expressed before attempting the conversion to a matrix.
}
\section{Warning!}{
 This conversion preserves the spectral data but discards
  almost all the metadata contained in the spectral objects. In other words a
  matrix created with this function cannot be used to recreate the original
  object unless the same metadata is explicitly supplied when converting the
  matrix into new collection of spectra.
}

