% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{generic_mspct}
\alias{generic_mspct}
\alias{calibration_mspct}
\alias{raw_mspct}
\alias{cps_mspct}
\alias{source_mspct}
\alias{filter_mspct}
\alias{reflector_mspct}
\alias{object_mspct}
\alias{response_mspct}
\alias{chroma_mspct}
\title{Collection-of-spectra constructor}
\usage{
generic_mspct(l = NULL, class = "generic_spct", ncol = 1,
  byrow = FALSE, dim = c(length(l)\%/\%ncol, ncol))

calibration_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

raw_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

cps_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

source_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

filter_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

reflector_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

object_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

response_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)

chroma_mspct(l = NULL, ncol = 1, byrow = FALSE, ...)
}
\arguments{
\item{l}{list of generic_spct or derived classes}

\item{class}{character The multi spectrum object class or the expected class
for the elements of l}

\item{ncol}{integer Number of 'virtual' columns in data}

\item{byrow}{logical If \code{ncol > 1} how to read in the data}

\item{dim}{integer vector of dimensions}

\item{...}{ignored}
}
\description{
Converts a list of spectral objects into a "multi spectrum"
  object by setting the class attribute of the list of spectra to the
  corresponding multi-spct class, check that components of the list belong to
  the expected class.
}
\section{Functions}{
\itemize{
\item \code{calibration_mspct}: Specialization for collections of \code{calibration_spct} objects.

\item \code{raw_mspct}: Specialization for collections of \code{raw_spct} objects.

\item \code{cps_mspct}: Specialization for collections of \code{cps_spct} objects.

\item \code{source_mspct}: Specialization for collections of \code{source_spct} objects.

\item \code{filter_mspct}: Specialization for collections of \code{filter_spct} objects.

\item \code{reflector_mspct}: Specialization for collections of \code{reflector_spct} objects.

\item \code{object_mspct}: Specialization for collections of \code{object_spct} objects.

\item \code{response_mspct}: Specialization for collections of \code{response_spct} objects.

\item \code{chroma_mspct}: Specialization for collections of \code{chroma_spct} objects.
}}

\note{
Setting class = source_spct or class = source_mspct makes no difference
}
\examples{
filter_mspct(list(polyester.spct, yellow_gel.spct))

}
\concept{collections of spectra classes family}
