% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.new.r
\name{split_bands}
\alias{split_bands}
\title{List-of-wavebands constructor}
\usage{
split_bands(x, list.names = NULL, short.names = is.null(list.names),
  length.out = NULL)
}
\arguments{
\item{x}{a numeric vector of wavelengths to split at (nm), or a range of
wavelengths or a generic_spct or a waveband.}

\item{list.names}{character vector with names for the component wavebands in
the returned list (in order of increasing wavelength)}

\item{short.names}{logical indicating whether to use short or long names for
wavebands}

\item{length.out}{numeric giving the number of regions to split the range
into (ignored if w.length is not numeric).}
}
\value{
an un-named list of waveband objects
}
\description{
Build a list of unweighted "waveband" objects that can be used as input when
calculating irradiances.
}
\note{
\code{list.names} is used to assign names to the elements of the list,
  while the waveband objects themselves always retain their \code{wb.label}
  and \code{wb.name} as generated during their creation.
}
\examples{
split_bands(c(400,500,600))
split_bands(list(c(400,500),c(550,650)))
split_bands(list(A=c(400,500),B=c(550,650)))
split_bands(c(400,500,600), short.names=FALSE)
split_bands(c(400,500,600), list.names=c("a","b"))
split_bands(c(400,700), length.out=6)
split_bands(400:700, length.out=3)
split_bands(sun.spct, length.out=10)
split_bands(waveband(c(400,700)), length.out=5)

}
\seealso{
Other waveband constructors: \code{\link{waveband}}
}
\concept{waveband constructors}
