% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{find_wls}
\alias{find_wls}
\title{Find wavelength values in a spectrum}
\usage{
find_wls(x, target = NULL, col.name.x = NULL, col.name = NULL,
  .fun = `<=`, interpolate = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{an R object}

\item{target}{numeric value indicating the spectral quantity value for which
wavelengths are to be searched and interpolated if need. The character
strings "half.maximum" and "half.range" are also accepted as arguments.}

\item{col.name.x}{character The name of the column in which to the
independent variable is stored. Defaults to "w.length" for objects of
class \code{"generic_spct"} or derived.}

\item{col.name}{character The name of the column in which to
search for the target value.}

\item{.fun}{function A binary comparison function or operator.}

\item{interpolate}{logical Indicating whether the nearest wavelength value
in \code{x} should be returned or a value calculated by linear
interpolation between wavelength values stradling the target.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for the target.}
}
\value{
A spectrum object of the same class as \code{x} with fewer rows,
  possibly even no rows. If \code{FALSE} is passed to \code{interpolate} a
  subset of \code{x} is returned, otherwise a new object of the same class
  containing interpolated wavelenths for the \code{target} value is
  returned.
}
\description{
Find wavelength values corresponding to a target y value in any spectrum. The
name of the column of the spectral data to be used to match the target needs
to be passed as argument unless the spectrum contains a single numerical
variable in addition to "w.length".
}
\note{
This function is used internally by method \code{wls_at_target()}, and
  these methods should be preferred in user code and scripts.
}
