% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.fscale.r, R/spct.fshift.r
\name{fscale}
\alias{fscale}
\alias{fscale.default}
\alias{fscale.filter_mspct}
\alias{fscale.filter_spct}
\alias{fscale.reflector_mspct}
\alias{fscale.reflector_spct}
\alias{fscale.response_mspct}
\alias{fscale.response_spct}
\alias{fscale.source_mspct}
\alias{fscale.source_spct}
\alias{fshift.default}
\title{Rescale a spectrum using a summary function}
\usage{
fscale(x, ...)

\method{fscale}{default}(x, ...)

\method{fscale}{source_spct}(x, range = NULL, f = "mean",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...)

\method{fscale}{response_spct}(x, range = NULL, f = "mean",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...)

\method{fscale}{filter_spct}(x, range = NULL, f = "mean",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  ...)

\method{fscale}{reflector_spct}(x, range = NULL, f = "mean",
  qty.out = NULL, ...)

\method{fscale}{source_mspct}(x, range = NULL, f = "mean",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...)

\method{fscale}{response_mspct}(x, range = NULL, f = "mean",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...)

\method{fscale}{filter_mspct}(x, range = NULL, f = "mean",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  ...)

\method{fscale}{reflector_mspct}(x, range = NULL, f = "mean",
  qty.out = NULL, ...)

\method{fshift}{default}(x, ...)
}
\arguments{
\item{x}{An R object}

\item{...}{additonal named arguments passed down to \code{f}.}

\item{range}{An R object on which \code{range()} returns a numeric vector of
length 2 with the limits of a range of wavelengths in nm, with min annd max
wavelengths (nm)}

\item{f}{character string "mean" or "total" for scaling so taht this summary
value becomes 1 for the returned object, or the name of a function taking
\code{x} as first argument and returning a numeric value.}

\item{unit.out}{character Alowed values "energy", and "photon", or its alias
"quantum"}

\item{qty.out}{character Allowed values "transmittance", and "absorbance"}
}
\value{
a new object of the same class as \code{x}.

a new object of the same class as \code{x}.
}
\description{
These functions return a spectral object of the same class as the one supplied
as argument but with the spectral data rescaled.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: 

\item \code{response_spct}: 

\item \code{filter_spct}: 

\item \code{reflector_spct}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{filter_mspct}: 

\item \code{reflector_mspct}: 

\item \code{default}: Default for generic function
}}
\seealso{
Other rescaling functions: \code{\link{fshift}},
  \code{\link{getNormalized}}, \code{\link{is_normalized}},
  \code{\link{is_scaled}}, \code{\link{normalize}},
  \code{\link{setNormalized}}, \code{\link{setScaled}}
}

