#' Filter spectra data for McDermit Autostat CT5 "polyester" filter
#'
#' Datasets containing the wavelengths at a 1 nm interval and
#' tabulated values spectral transmittance for filter.
#'
#' The variables are as follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item Tfr (fraction)
#' }
#' \url{http://www.macdermidautotype.com/}
#'
#' @note Instrument used: Shimadzu UV-2501 PC (Shimadzu Suzhou Instruments Manufacturing
#' Co. Ltd, China) equiped with an integrating sphere.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @examples
#' mcdermit
#'
"mcdermit"
