% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materials.r
\docType{data}
\name{acetate_filters}
\alias{acetate_filters}
\alias{acrylic_filters}
\alias{polycarbonate_filters}
\alias{plexiglas_filters}
\alias{polystyrene_filters}
\alias{polyester_filters}
\alias{polyvynil_chloride_filters}
\alias{optical_glass_filters}
\alias{plastic_film_filters}
\alias{plastic_films}
\alias{plastic_sheet_filters}
\alias{plastic_sheets}
\alias{plastic_dome_filters}
\alias{plastic_domes}
\title{Indexing of filters made from different materials}
\format{
A vector of character strings.

An object of class \code{character} of length 9.

An object of class \code{character} of length 3.

An object of class \code{character} of length 9.

An object of class \code{character} of length 3.

An object of class \code{character} of length 2.

An object of class \code{character} of length 1.

An object of class \code{character} of length 68.

An object of class \code{character} of length 31.

An object of class \code{character} of length 31.

An object of class \code{character} of length 14.

An object of class \code{character} of length 14.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.
}
\usage{
acetate_filters

acrylic_filters

polycarbonate_filters

plexiglas_filters

polystyrene_filters

polyester_filters

polyvynil_chloride_filters

optical_glass_filters

plastic_film_filters

plastic_films

plastic_sheet_filters

plastic_sheets

plastic_dome_filters

plastic_domes
}
\description{
Vectors of names of member objects containing fractional spectral
transmittance data for films (very flexible) and sheets (rigid or nearly
rigid) grouped by the material they are made of.
}
\details{
The vectors can be used to extract subsets of spectra from the
 collection in \code{filter.mspct}. Some spectra are included in more
 than one vector.
}
\examples{
acrylic_filters

# extract spectral data for filters made from acrylic
filters.mspct[acrylic_filters]

}
\seealso{
\code{\link{filters.mspct}}
}
\keyword{datasets}
