#' Spectral data for LEDs array supplied by Shenzhen Weili Optical
#'
#' Names of datasets containing the wavelengths and tabulated values spectral emittance
#' for different light emitting diodes (LEDs) arrays from Shenzhen Weili Optical
#' Ltd.  Data are normalized to one at the wavelength of maximum emission.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @aliases shenzhen_weili
#' @examples
#' shenzhen_weili
#' leds_global
#'
#' @note
#' Leds Global and Shenzhen Weili are trade names of the same supplier of LED
#' arrays. They sell both standard types and also assemble customized arrays
#' upon request. Customized arrays may have up to five independent channels.
#'
#' @references \url{http://www.leds-global.com/}
#'
#' @seealso \code{\link{leds.mspct}}
#' 
#' @family manufacturers
#' 
"leds_global"
