% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-colors.r
\docType{data}
\name{lamp_colors}
\alias{lamp_colors}
\alias{'lamps}
\alias{by}
\alias{color'}
\alias{uv_lamps}
\alias{purple_lamps}
\alias{ir_lamps}
\alias{blue_lamps}
\alias{green_lamps}
\alias{yellow_lamps}
\alias{orange_lamps}
\alias{red_lamps}
\alias{amber_lamps}
\alias{white_lamps}
\title{Spectral data for Lamps of different colours}
\format{
A vector of character strings.

An object of class \code{character} of length 8.

An object of class \code{character} of length 14.

An object of class \code{character} of length 5.

An object of class \code{character} of length 10.

An object of class \code{character} of length 3.

An object of class \code{character} of length 1.

An object of class \code{character} of length 7.

An object of class \code{character} of length 14.

An object of class \code{character} of length 8.

An object of class \code{character} of length 37.
}
\usage{
lamp_colors

uv_lamps

purple_lamps

ir_lamps

blue_lamps

green_lamps

yellow_lamps

orange_lamps

red_lamps

amber_lamps

white_lamps
}
\description{
Names of members of the collection of emission spectra
\code{\link{lamps.mspct}} grouped by the wavelength at which they emit.
}
\details{
The character vectors \code{"uv_leds"}, \code{"purple_leds"},
\code{"blue_leds"}, \code{"green_leds"}, \code{"yellow_leds"},
\code{"orange_leds"} and \code{"red_leds"} contain the names of the members
of \code{lamps.mspct} with peaks of emission within the wavelength range
corresponding to the light colours as defined by ISO standards. Vector
\code{amber_lamps} is the union of \code{"yellow_lamps"} and
\code{"orange_lamps"}. Vector \code{white_lamps} contains the names of spectra
for lamps with broad or multiple peaks of emission in the visible range.
Vectors \code{"uv_lamps"} and \code{"ir_lamps"} contain the names for lamps with
peak emission at wavelengths < 400 nm and wavelengths > 700 nm, respectively.

These vectors can be used to extract subsets of spectra from
\code{lamps.mspct}.
}
\examples{
uv_lamps
blue_lamps
red_lamps
white_lamps

# select data for lamps  emitting in the ultraviolet region
lamps.mspct[uv_lamps]

}
\seealso{
\code{\link{lamps.mspct}}
}
\keyword{datasets}
