% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant-qq-ratios.r
\name{B_G}
\alias{B_G}
\title{Calculate B:G photon ratio from spectral irradiance.}
\usage{
B_G(spct, std = "Sellaro", use.cached.mult = FALSE, use.hinges = TRUE)
}
\arguments{
\item{spct}{an object of class "source.spct"}

\item{std}{select which definition of blue and green should be used,
defaults to "Sellaro"}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}
}
\value{
a single numeric nondimensional value giving the B:G photon ratio,
  with name attribute set to the name of the wavebands, with "(q:q)"
  appended.
}
\description{
This function returns the blue:green photon ratio of a light source spectrum.
}
\examples{
B_G(sun.spct)

}
\keyword{manip}
\keyword{misc}

