% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photobiologyPlants.r
\docType{package}
\name{photobiologyPlants-package}
\alias{photobiologyPlants}
\alias{photobiologyPlants-package}
\title{photobiologyPlants: Plant Photobiology Related Functions and Data}
\description{
Provides functions for quantifying visible (VIS) and ultraviolet
(UV) radiation in relation to the photoreceptors Phytochromes,
Cryptochromes, and UVR8 which are present in plants. It also
includes data sets on the optical properties of plants.
}
\details{
Package 'photobiologyPlants' is part of a suite of packages for
  analysis and plotting of data relevant to photobiology (described at
  \url{http://www.r4photobiology.info/}). The current component package
  provides functions and data related to plant photoreceptors, light
  dependent reponses and optical properties of plants.
}
\section{Acknowledgements}{
 This work was partly funded by the Academy of
  Finland (decision 252548). COST Action FA9604 'UV4Growth' facilitated
  discussions and exchanges of ideas that lead to the development of this
  package.
}

\references{
Aphalo, P. J., Albert, A., Björn, L. O., McLeod, A. R., Robson, T. M.,
Rosenqvist, E. (Eds.). (2012). Beyond the Visible: A handbook of best
practice in plant UV photobiology (1st ed., p. xxx + 174). Helsinki:
University of Helsinki, Department of Biosciences, Division of Plant Biology.
ISBN 978-952-10-8363-1 (PDF), 978-952-10-8362-4 (paperback). Open access PDF
download available at \url{http://hdl.handle.net/10138/37558}

Mancinelli, A.L. (1994) The physiology of phytochrome action. In
Photomorphogenesis in plants, 2nd edition. R.E. Kendrick and G.H.M.
Kronenberg, eds. Kluwer Academic Publishers, Dordrecht, pp. 211-269. ISBN
978-0-7923-2551-2 (print), 978-94-011-1884-2 (on-line).
\href{http://dx.doi.org/10.1007/978-94-011-1884-2_10}{DOI
10.1007/978-94-011-1884-2_10}

Banerjee, R., Schleicher, E., Meier, S., Viana, R. M., Pokorny, R., Ahmad,
M., … Batschauer, A. (2007). The signaling state of Arabidopsis cryptochrome
2 contains flavin semiquinone. J Biol Chem, 282(20), 14916–14922.
\href{http://dx.doi.org/10.1074/jbc.M700616200}{DOI 10.1074/jbc.M700616200}
}
\seealso{
Package \code{\link[photobiology]{photobiology-package}}
}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi}

}
