% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uvc.r
\name{UVC}
\alias{UVC}
\title{Constructor of ultraviolet-C waveband}
\usage{
UVC(std = "ISO")
}
\arguments{
\item{std}{a character string "CIE", "ISO", "none", or "medical".}
}
\value{
a waveband object wavelength defining a wavelength range.
}
\description{
Wavelength-range definitions for \emph{ultraviolet-C (UV-C)} radiation, by
default according to ISO or as commonly used in different application areas.
}
\details{
Implemented definitions.  UV-C according to CIE and ISO standards:
  100--280 nm. UV-c according to common non-standard practice: 200--280 nm.
  UV-C according to medical or dermatological non-standard practice, e.g.
  Diffey (1991): 200--290 nm.
}
\examples{
UVC()
UVC("CIE")
UVC("ISO")
UVC("none")
UVC("medical")

}
\references{
Aphalo, P. J., Albert, A., Björn, L. O., McLeod, A. R., Robson,
T. M., Rosenqvist, E. (Eds.). (2012). Beyond the Visible: A handbook of best
practice in plant UV photobiology (1st ed., p. xxx + 174). Helsinki:
University of Helsinki, Department of Biosciences, Division of Plant Biology.
ISBN 978-952-10-8363-1 (PDF), 978-952-10-8362-4 (paperback). Open access PDF
download available at \doi{10.31885/9789521083631}.
}
\seealso{
\code{\link{new_waveband}}  \code{\link{waveband}}

Other unweighted wavebands: 
\code{\link{Blue}()},
\code{\link{Far_red}()},
\code{\link{Green}()},
\code{\link{IR}()},
\code{\link{Orange}()},
\code{\link{Purple}()},
\code{\link{Red}()},
\code{\link{UVA}()},
\code{\link{UVB}()},
\code{\link{UV}()},
\code{\link{VIS}()},
\code{\link{Yellow}()}
}
\concept{unweighted wavebands}
